//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#ifndef __EZFB_COLOR_MAP_FUNCTIONS__
#define __EZFB_COLOR_MAP_FUNCTIONS__

//############################################################################

#include "ezfb_types.h"

//############################################################################
int      ezfb_get_cmap                 (struct ezfb* fb);
int      ezfb_set_cmap                 (struct ezfb* fb);
int      ezfb_get_color_factors        (struct ezfb* fb);
int      ezfb_init_cmap                (struct ezfb* fb, int save_old);
int      ezfb_clear_cmap               (struct ezfb* fb);
int      ezfb_release_cmap             (struct ezfb* fb);
int      ezfb_find_black_and_white     (struct ezfb* fb);
u_int    ezfb_make_rgb                 (struct ezfb* fb, u_short r, u_short g, u_short b);
u_short  ezfb_get_r_from_rgb           (struct ezfb* fb, u_int rgb);
u_short  ezfb_get_g_from_rgb           (struct ezfb* fb, u_int rgb);
u_short  ezfb_get_b_from_rgb           (struct ezfb* fb, u_int rgb);
u_short  ezfb_get_1bit_from_rgb        (u_short r, u_short g, u_short b);
u_short  ezfb_get_4bit_from_rgb        (u_short r, u_short g, u_short b);
u_int    ezfb_rgb_hue                  (struct ezfb* fb, u_short index);
u_int    ezfb_rgb_tint                 (struct ezfb* fb, u_short index, u_char tint);
u_int    ezfb_rgb_shade                (struct ezfb* fb, u_short index, u_char shade);
int      ezfb_set_cmap_to_was          (struct ezfb* fb);
int      ezfb_set_cmap_grays           (struct ezfb* fb);
int      ezfb_set_cmap_reds            (struct ezfb* fb);
int      ezfb_set_cmap_greens          (struct ezfb* fb);
int      ezfb_set_cmap_blues           (struct ezfb* fb);
int      ezfb_set_cmap_hues            (struct ezfb* fb);
int      ezfb_set_cmap_utility         (struct ezfb* fb);
int      ezfb_set_cmap_smooth          (struct ezfb* fb);
int      ezfb_set_cmap_random          (struct ezfb* fb);
int      ezfb_set_cmap_reduction       (struct ezfb* fb);
void     ezfb_set_cmap_index           (struct ezfb* fb, int i, u_short  r, u_short  g, u_short  b);
void     ezfb_get_cmap_index           (struct ezfb* fb, int i, u_short* r, u_short* g, u_short* b);
u_short  ezfb_get_r_from_cmap_index    (struct ezfb* fb, int i);
u_short  ezfb_get_g_from_cmap_index    (struct ezfb* fb, int i);
u_short  ezfb_get_b_from_cmap_index    (struct ezfb* fb, int i);
int      ezfb_cycle_cmap               (struct ezfb* fb, u_char from_index, u_char to_index, int step);
int      ezfb_set_background           (struct ezfb* fb, u_int rgb);
int      ezfb_dump_colors              (struct ezfb* fb);
int      ezfb_dump_cmap                (struct ezfb* fb);
int      ezfb_dump_cmap_values         (struct ezfb* fb);
int      ezfb_dump_cmap_was_values     (struct ezfb* fb);
int      ezfb_binfile_cmap             (struct ezfb* fb, char* file_name);
//############################################################################
#endif

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################


















