//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

//############################################################################
#ifndef __EZFB_FRAME_BUFFER_LIB__
#define __EZFB_FRAME_BUFFER_LIB__

//############################################################################

#include "ezfb_types.h"

//############################################################################
extern struct ezfb* valid_ezfb[EZFB_MAX_FB_NUM + 1];
extern u_int        num_valid_ezfb;

//############################################################################
int    ezfb_dev_exists              (char*  dev_name);
int    ezfb_num_exists              (int    num     );
u_int  ezfb_name_to_num             (char*  dev_name);
int    ezfb_init                    (struct ezfb* fb);
int    ezfb_init_no_save            (struct ezfb* fb);
int    ezfb_init_num                (struct ezfb* fb, u_int dev_num);
int    ezfb_init_num_no_save        (struct ezfb* fb, u_int dev_num);
int    ezfb_init_named              (struct ezfb* fb, char* dev_name);
int    ezfb_init_named_no_save      (struct ezfb* fb, char* dev_name);
int    ezfb_set_bpp                 (struct ezfb* fb, u_int bpp_wanted);
int    ezfb_set_xy_virtual          (struct ezfb* fb, u_int xvirt, u_int yvirt);
int    ezfb_set_xy_offsets          (struct ezfb* fb, int   xoff , int   yoff );
//int    ezfb_set_resolution          (struct ezfb* fb, int new_xres, int new_yres);
int    ezfb_clear                   (struct ezfb* fb);
int    ezfb_clear_screen            (struct ezfb* fb);
int    ezfb_release                 (struct ezfb* fb);
int    ezfb_dump_fb_fix_screeninfo  (struct ezfb* fb);
int    ezfb_dump_fb_var_screeninfo  (struct ezfb* fb);
int    ezfb_dump                    (struct ezfb* fb);
int    ezfb_dump_screen_map         (struct ezfb* fb);
int    ezfb_dump_virtual_map        (struct ezfb* fb);
int    ezfb_binfile_screen_map      (struct ezfb* fb, char* file_name);
int    ezfb_binfile_virtual_map     (struct ezfb* fb, char* file_name);
float  ezfb_random_01               ();
float  ezfb_random_neg_to_pos_1     ();

//############################################################################
#endif

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################















