//############################################################################
//
// ezfb_laser_palettes.c
//
// ~ International Laser Display Association ~
// ~     ILDA File Format Driver in C++      ~
// ~             Built for EZFB              ~
//
// by James Lehman
// james@akrobiz.com
//
// began: October 2003
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#include "ezfb_colors.h"

//############################################################################
int ezfb_set_cmap_pangolin(struct ezfb* fb)
{
    u_int i;
EZFB_FUNCTION_CALL_0
    switch(fb->Var.bits_per_pixel)
    {
        case  1: ezfb_set_cmap_index(fb, 0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb, 1, 0xffff, 0xffff, 0xffff); // white
                 break;
        //--------------------------------------------------------------------
        case  2: ezfb_set_cmap_index(fb, 0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb, 1, 0xffff, 0x0000, 0xffff); // magenta
                 ezfb_set_cmap_index(fb, 2, 0x0000, 0xffff, 0xffff); // cyan
                 ezfb_set_cmap_index(fb, 3, 0xffff, 0xffff, 0xffff); // white
                 break;
        //--------------------------------------------------------------------
        case  4: ezfb_set_cmap_index(fb,    0, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    1, 0xff00, 0x1000, 0x0000);
                 ezfb_set_cmap_index(fb,    2, 0xff00, 0x2000, 0x0000);
                 ezfb_set_cmap_index(fb,    3, 0xff00, 0x3000, 0x0000);
                 ezfb_set_cmap_index(fb,    4, 0xff00, 0x4000, 0x0000);
                 ezfb_set_cmap_index(fb,    5, 0xff00, 0x5000, 0x0000);
                 ezfb_set_cmap_index(fb,    6, 0xff00, 0x6000, 0x0000);
                 ezfb_set_cmap_index(fb,    7, 0xff00, 0x7000, 0x0000);
                 ezfb_set_cmap_index(fb,    8, 0xff00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,    9, 0xff00, 0x9000, 0x0000);
                 ezfb_set_cmap_index(fb,   10, 0xff00, 0xa000, 0x0000);
                 ezfb_set_cmap_index(fb,   11, 0xff00, 0xb000, 0x0000);
                 ezfb_set_cmap_index(fb,   12, 0xff00, 0xc000, 0x0000);
                 ezfb_set_cmap_index(fb,   13, 0xff00, 0xd000, 0x0000);
                 ezfb_set_cmap_index(fb,   14, 0xff00, 0xe000, 0x0000);
                 ezfb_set_cmap_index(fb,   15, 0xff00, 0xf000, 0x0000);
                 break;
        //--------------------------------------------------------------------
        case  8:
        case 15:
        case 16:
        case 24:
        case 32: ezfb_set_cmap_index(fb,    0, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    1, 0xff00, 0x1000, 0x0000);
                 ezfb_set_cmap_index(fb,    2, 0xff00, 0x2000, 0x0000);
                 ezfb_set_cmap_index(fb,    3, 0xff00, 0x3000, 0x0000);
                 ezfb_set_cmap_index(fb,    4, 0xff00, 0x4000, 0x0000);
                 ezfb_set_cmap_index(fb,    5, 0xff00, 0x5000, 0x0000);
                 ezfb_set_cmap_index(fb,    6, 0xff00, 0x6000, 0x0000);
                 ezfb_set_cmap_index(fb,    7, 0xff00, 0x7000, 0x0000);
                 ezfb_set_cmap_index(fb,    8, 0xff00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,    9, 0xff00, 0x9000, 0x0000);
                 ezfb_set_cmap_index(fb,   10, 0xff00, 0xa000, 0x0000);
                 ezfb_set_cmap_index(fb,   11, 0xff00, 0xb000, 0x0000);
                 ezfb_set_cmap_index(fb,   12, 0xff00, 0xc000, 0x0000);
                 ezfb_set_cmap_index(fb,   13, 0xff00, 0xd000, 0x0000);
                 ezfb_set_cmap_index(fb,   14, 0xff00, 0xe000, 0x0000);
                 ezfb_set_cmap_index(fb,   15, 0xff00, 0xf000, 0x0000);
                 ezfb_set_cmap_index(fb,   16, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   17, 0xe000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   18, 0xc000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   19, 0xa000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   20, 0x8000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   21, 0x6000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   22, 0x4000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   23, 0x2000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   24, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   25, 0x0000, 0xff00, 0x2000);
                 ezfb_set_cmap_index(fb,   26, 0x0000, 0xff00, 0x4000);
                 ezfb_set_cmap_index(fb,   27, 0x0000, 0xff00, 0x6000);
                 ezfb_set_cmap_index(fb,   28, 0x0000, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   29, 0x0000, 0xff00, 0xa000);
                 ezfb_set_cmap_index(fb,   30, 0x0000, 0xff00, 0xc000);
                 ezfb_set_cmap_index(fb,   31, 0x0000, 0xff00, 0xe000);
                 ezfb_set_cmap_index(fb,   32, 0x0000, 0x8200, 0xff00);
                 ezfb_set_cmap_index(fb,   33, 0x0000, 0x7200, 0xff00);
                 ezfb_set_cmap_index(fb,   34, 0x0000, 0x6800, 0xff00);
                 ezfb_set_cmap_index(fb,   35, 0x0a00, 0x6000, 0xff00);
                 ezfb_set_cmap_index(fb,   36, 0x0000, 0x5200, 0xff00);
                 ezfb_set_cmap_index(fb,   37, 0x0000, 0x4a00, 0xff00);
                 ezfb_set_cmap_index(fb,   38, 0x0000, 0x4000, 0xff00);
                 ezfb_set_cmap_index(fb,   39, 0x0000, 0x2000, 0xff00);
                 ezfb_set_cmap_index(fb,   40, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   41, 0x2000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   42, 0x4000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   43, 0x6000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   44, 0x8000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   45, 0xa000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   46, 0xe000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   47, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   48, 0xff00, 0x2000, 0xff00);
                 ezfb_set_cmap_index(fb,   49, 0xff00, 0x4000, 0xff00);
                 ezfb_set_cmap_index(fb,   50, 0xff00, 0x6000, 0xff00);
                 ezfb_set_cmap_index(fb,   51, 0xff00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   52, 0xff00, 0xa000, 0xff00);
                 ezfb_set_cmap_index(fb,   53, 0xff00, 0xc000, 0xff00);
                 ezfb_set_cmap_index(fb,   54, 0xff00, 0xe000, 0xff00);
                 ezfb_set_cmap_index(fb,   55, 0xff00, 0xff00, 0xff00); // white
                 ezfb_set_cmap_index(fb,   56, 0xff00, 0xe000, 0xe000);
                 ezfb_set_cmap_index(fb,   57, 0xff00, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,   58, 0xff00, 0xa000, 0xa000);
                 ezfb_set_cmap_index(fb,   59, 0xff00, 0x8000, 0x8000);
                 ezfb_set_cmap_index(fb,   60, 0xff00, 0x6000, 0x6000);
                 ezfb_set_cmap_index(fb,   61, 0xff00, 0x4000, 0x4000);
                 ezfb_set_cmap_index(fb,   62, 0xff00, 0x2000, 0x2000); // last unique

                 for(i = 63; i < 255; i++)
                    ezfb_set_cmap_index(fb, i, 0x0000, 0x0000, 0x0000); // black
                 break;
        //--------------------------------------------------------------------
    }
    if(fb->colors.exists && (fb->Var.bits_per_pixel <= 8))
    {
        ret =  ezfb_set_cmap(fb);
        ret &= ezfb_find_black_and_white(fb);
    }
EZFB_FUNCTION_RETURN(ret)
}

//############################################################################
int ezfb_set_cmap_laser_illusions(struct ezfb* fb)
{
EZFB_FUNCTION_CALL_0
    switch(fb->Var.bits_per_pixel)
    {
        case  1: ezfb_set_cmap_index(fb, 0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb, 1, 0xffff, 0xffff, 0xffff); // white
                 break;
        //--------------------------------------------------------------------
        case  2: ezfb_set_cmap_index(fb, 0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb, 1, 0xffff, 0x0000, 0xffff); // magenta
                 ezfb_set_cmap_index(fb, 2, 0x0000, 0xffff, 0xffff); // cyan
                 ezfb_set_cmap_index(fb, 3, 0xffff, 0xffff, 0xffff); // white
                 break;
        //--------------------------------------------------------------------
        case  4: ezfb_set_cmap_index(fb,    0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb,    1, 0xff00, 0xff00, 0xff00); // white
                 ezfb_set_cmap_index(fb,    2, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    3, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    4, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,    5, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    6, 0x0000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,    7, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,    8, 0xff00, 0x8000, 0x8000);
                 ezfb_set_cmap_index(fb,    9, 0xff00, 0x8c00, 0x8000);
                 ezfb_set_cmap_index(fb,   10, 0xff00, 0x9700, 0x8000);
                 ezfb_set_cmap_index(fb,   11, 0xff00, 0xa300, 0x8000);
                 ezfb_set_cmap_index(fb,   12, 0xff00, 0xae00, 0x8000);
                 ezfb_set_cmap_index(fb,   13, 0xff00, 0xba00, 0x8000);
                 ezfb_set_cmap_index(fb,   14, 0xff00, 0xc500, 0x8000);
                 ezfb_set_cmap_index(fb,   15, 0xff00, 0xd100, 0x8000);
                 break;
        //--------------------------------------------------------------------
        case  8:
        case 15:
        case 16:
        case 24:
        case 32: ezfb_set_cmap_index(fb,    0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb,    1, 0xff00, 0xff00, 0xff00); // white
                 ezfb_set_cmap_index(fb,    2, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    3, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    4, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,    5, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    6, 0x0000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,    7, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,    8, 0xff00, 0x8000, 0x8000);
                 ezfb_set_cmap_index(fb,    9, 0xff00, 0x8c00, 0x8000);
                 ezfb_set_cmap_index(fb,   10, 0xff00, 0x9700, 0x8000);
                 ezfb_set_cmap_index(fb,   11, 0xff00, 0xa300, 0x8000);
                 ezfb_set_cmap_index(fb,   12, 0xff00, 0xae00, 0x8000);
                 ezfb_set_cmap_index(fb,   13, 0xff00, 0xba00, 0x8000);
                 ezfb_set_cmap_index(fb,   14, 0xff00, 0xc500, 0x8000);
                 ezfb_set_cmap_index(fb,   15, 0xff00, 0xd100, 0x8000);
                 ezfb_set_cmap_index(fb,   16, 0xff00, 0xdc00, 0x8000);
                 ezfb_set_cmap_index(fb,   17, 0xff00, 0xe800, 0x8000);
                 ezfb_set_cmap_index(fb,   18, 0xff00, 0xf300, 0x8000);
                 ezfb_set_cmap_index(fb,   19, 0xff00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   20, 0xf300, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   21, 0xe800, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   22, 0xdc00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   23, 0xd100, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   24, 0xc500, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   25, 0xba00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   26, 0xae00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   27, 0xa300, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   28, 0x9700, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   29, 0x8c00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   30, 0x8000, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   31, 0x8000, 0xff00, 0x8c00);
                 ezfb_set_cmap_index(fb,   32, 0x8000, 0xff00, 0x9700);
                 ezfb_set_cmap_index(fb,   33, 0x8000, 0xff00, 0xa300);
                 ezfb_set_cmap_index(fb,   34, 0x8000, 0xff00, 0xae00);
                 ezfb_set_cmap_index(fb,   35, 0x8000, 0xff00, 0xba00);
                 ezfb_set_cmap_index(fb,   36, 0x8000, 0xff00, 0xc500);
                 ezfb_set_cmap_index(fb,   37, 0x8000, 0xff00, 0xd100);
                 ezfb_set_cmap_index(fb,   38, 0x8000, 0xff00, 0xdc00);
                 ezfb_set_cmap_index(fb,   39, 0x8000, 0xff00, 0xe800);
                 ezfb_set_cmap_index(fb,   40, 0x8000, 0xff00, 0xf300);
                 ezfb_set_cmap_index(fb,   41, 0x8000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,   42, 0x8000, 0xf300, 0xff00);
                 ezfb_set_cmap_index(fb,   43, 0x8000, 0xe800, 0xff00);
                 ezfb_set_cmap_index(fb,   44, 0x8000, 0xdc00, 0xff00);
                 ezfb_set_cmap_index(fb,   45, 0x8000, 0xd100, 0xff00);
                 ezfb_set_cmap_index(fb,   46, 0x8000, 0xc500, 0xff00);
                 ezfb_set_cmap_index(fb,   47, 0x8000, 0xba00, 0xff00);
                 ezfb_set_cmap_index(fb,   48, 0x8000, 0xae00, 0xff00);
                 ezfb_set_cmap_index(fb,   49, 0x8000, 0xa300, 0xff00);
                 ezfb_set_cmap_index(fb,   50, 0x8000, 0x9700, 0xff00);
                 ezfb_set_cmap_index(fb,   51, 0x8000, 0x8c00, 0xff00);
                 ezfb_set_cmap_index(fb,   52, 0x8000, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   53, 0x8c00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   54, 0x9700, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   55, 0xa300, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   56, 0xae00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   57, 0xba00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   58, 0xc500, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   59, 0xd100, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   60, 0xdc00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   61, 0xe800, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   62, 0xf300, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   63, 0xff00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   64, 0xff00, 0x8000, 0xf300);
                 ezfb_set_cmap_index(fb,   65, 0xff00, 0x8000, 0xe800);
                 ezfb_set_cmap_index(fb,   66, 0xff00, 0x8000, 0xdc00);
                 ezfb_set_cmap_index(fb,   67, 0xff00, 0x8000, 0xd100);
                 ezfb_set_cmap_index(fb,   68, 0xff00, 0x8000, 0xc500);
                 ezfb_set_cmap_index(fb,   69, 0xff00, 0x8000, 0xba00);
                 ezfb_set_cmap_index(fb,   70, 0xff00, 0x8000, 0xae00);
                 ezfb_set_cmap_index(fb,   71, 0xff00, 0x8000, 0xa300);
                 ezfb_set_cmap_index(fb,   72, 0xff00, 0x8000, 0x9700);
                 ezfb_set_cmap_index(fb,   73, 0xff00, 0x8000, 0x8c00);
                 ezfb_set_cmap_index(fb,   74, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,   75, 0xff00, 0x1700, 0x0000);
                 ezfb_set_cmap_index(fb,   76, 0xff00, 0x2e00, 0x0000);
                 ezfb_set_cmap_index(fb,   77, 0xff00, 0x4600, 0x0000);
                 ezfb_set_cmap_index(fb,   78, 0xff00, 0x5d00, 0x0000);
                 ezfb_set_cmap_index(fb,   79, 0xff00, 0x7400, 0x0000);
                 ezfb_set_cmap_index(fb,   80, 0xff00, 0x8b00, 0x0000);
                 ezfb_set_cmap_index(fb,   81, 0xff00, 0xa200, 0x0000);
                 ezfb_set_cmap_index(fb,   82, 0xff00, 0xb900, 0x0000);
                 ezfb_set_cmap_index(fb,   83, 0xff00, 0xd100, 0x0000);
                 ezfb_set_cmap_index(fb,   84, 0xff00, 0xe800, 0x0000);
                 ezfb_set_cmap_index(fb,   85, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   86, 0xe800, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   87, 0xd100, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   88, 0xb900, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   89, 0xa200, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   90, 0x8b00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   91, 0x7400, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   92, 0x5d00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   93, 0x4600, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   94, 0x2e00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   95, 0x1700, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   96, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   97, 0x0000, 0xff00, 0x1700);
                 ezfb_set_cmap_index(fb,   98, 0x0000, 0xff00, 0x2e00);
                 ezfb_set_cmap_index(fb,   99, 0x0000, 0xff00, 0x4600);
                 ezfb_set_cmap_index(fb,  100, 0x0000, 0xff00, 0x5d00);
                 ezfb_set_cmap_index(fb,  101, 0x0000, 0xff00, 0x7400);
                 ezfb_set_cmap_index(fb,  102, 0x0000, 0xff00, 0x8b00);
                 ezfb_set_cmap_index(fb,  103, 0x0000, 0xff00, 0xa200);
                 ezfb_set_cmap_index(fb,  104, 0x0000, 0xff00, 0xb900);
                 ezfb_set_cmap_index(fb,  105, 0x0000, 0xff00, 0xd100);
                 ezfb_set_cmap_index(fb,  106, 0x0000, 0xff00, 0xe800);
                 ezfb_set_cmap_index(fb,  107, 0x0000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,  108, 0x0000, 0xe800, 0xff00);
                 ezfb_set_cmap_index(fb,  109, 0x0000, 0xd100, 0xff00);
                 ezfb_set_cmap_index(fb,  110, 0x0000, 0xb900, 0xff00);
                 ezfb_set_cmap_index(fb,  111, 0x0000, 0xa200, 0xff00);
                 ezfb_set_cmap_index(fb,  112, 0x0000, 0x8b00, 0xff00);
                 ezfb_set_cmap_index(fb,  113, 0x0000, 0x7400, 0xff00);
                 ezfb_set_cmap_index(fb,  114, 0x0000, 0x5d00, 0xff00);
                 ezfb_set_cmap_index(fb,  115, 0x0000, 0x4600, 0xff00);
                 ezfb_set_cmap_index(fb,  116, 0x0000, 0x2e00, 0xff00);
                 ezfb_set_cmap_index(fb,  117, 0x0000, 0x1700, 0xff00);
                 ezfb_set_cmap_index(fb,  118, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  119, 0x1700, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  120, 0x2e00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  121, 0x4600, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  122, 0x5d00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  123, 0x7400, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  124, 0x8b00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  125, 0xa200, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  126, 0xb900, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  127, 0xd100, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  128, 0xe800, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  129, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  130, 0xff00, 0x0000, 0xe800);
                 ezfb_set_cmap_index(fb,  131, 0xff00, 0x0000, 0xd100);
                 ezfb_set_cmap_index(fb,  132, 0xff00, 0x0000, 0xb900);
                 ezfb_set_cmap_index(fb,  133, 0xff00, 0x0000, 0xa200);
                 ezfb_set_cmap_index(fb,  134, 0xff00, 0x0000, 0x8b00);
                 ezfb_set_cmap_index(fb,  135, 0xff00, 0x0000, 0x7400);
                 ezfb_set_cmap_index(fb,  136, 0xff00, 0x0000, 0x5d00);
                 ezfb_set_cmap_index(fb,  137, 0xff00, 0x0000, 0x4600);
                 ezfb_set_cmap_index(fb,  138, 0xff00, 0x0000, 0x2e00);
                 ezfb_set_cmap_index(fb,  139, 0xff00, 0x0000, 0x1700);
                 ezfb_set_cmap_index(fb,  140, 0x8000, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,  141, 0x8000, 0x0c00, 0x0000);
                 ezfb_set_cmap_index(fb,  142, 0x8000, 0x1700, 0x0000);
                 ezfb_set_cmap_index(fb,  143, 0x8000, 0x2300, 0x0000);
                 ezfb_set_cmap_index(fb,  144, 0x8000, 0x2f00, 0x0000);
                 ezfb_set_cmap_index(fb,  145, 0x8000, 0x3a00, 0x0000);
                 ezfb_set_cmap_index(fb,  146, 0x8000, 0x4600, 0x0000);
                 ezfb_set_cmap_index(fb,  147, 0x8000, 0x5100, 0x0000);
                 ezfb_set_cmap_index(fb,  148, 0x8000, 0x5d00, 0x0000);
                 ezfb_set_cmap_index(fb,  149, 0x8000, 0x6900, 0x0000);
                 ezfb_set_cmap_index(fb,  150, 0x8000, 0x7400, 0x0000);
                 ezfb_set_cmap_index(fb,  151, 0x8000, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  152, 0x7400, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  153, 0x6900, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  154, 0x5d00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  155, 0x5100, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  156, 0x4600, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  157, 0x3a00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  158, 0x2f00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  159, 0x2300, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  160, 0x1700, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  161, 0x0c00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  162, 0x0000, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  163, 0x0000, 0x8000, 0x0c00);
                 ezfb_set_cmap_index(fb,  164, 0x0000, 0x8000, 0x1700);
                 ezfb_set_cmap_index(fb,  165, 0x0000, 0x8000, 0x2300);
                 ezfb_set_cmap_index(fb,  166, 0x0000, 0x8000, 0x2f00);
                 ezfb_set_cmap_index(fb,  167, 0x0000, 0x8000, 0x3a00);
                 ezfb_set_cmap_index(fb,  168, 0x0000, 0x8000, 0x4600);
                 ezfb_set_cmap_index(fb,  169, 0x0000, 0x8000, 0x5100);
                 ezfb_set_cmap_index(fb,  170, 0x0000, 0x8000, 0x5d00);
                 ezfb_set_cmap_index(fb,  171, 0x0000, 0x8000, 0x6900);
                 ezfb_set_cmap_index(fb,  172, 0x0000, 0x8000, 0x7400);
                 ezfb_set_cmap_index(fb,  173, 0x0000, 0x8000, 0x8000);
                 ezfb_set_cmap_index(fb,  174, 0x0000, 0x7400, 0x8000);
                 ezfb_set_cmap_index(fb,  175, 0x0000, 0x6900, 0x8000);
                 ezfb_set_cmap_index(fb,  176, 0x0000, 0x5d00, 0x8000);
                 ezfb_set_cmap_index(fb,  177, 0x0000, 0x5100, 0x8000);
                 ezfb_set_cmap_index(fb,  178, 0x0000, 0x4600, 0x8000);
                 ezfb_set_cmap_index(fb,  179, 0x0000, 0x3a00, 0x8000);
                 ezfb_set_cmap_index(fb,  180, 0x0000, 0x2f00, 0x8000);
                 ezfb_set_cmap_index(fb,  181, 0x0000, 0x2300, 0x8000);
                 ezfb_set_cmap_index(fb,  182, 0x0000, 0x1700, 0x8000);
                 ezfb_set_cmap_index(fb,  183, 0x0000, 0x0c00, 0x8000);
                 ezfb_set_cmap_index(fb,  184, 0x0000, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  185, 0x0c00, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  186, 0x1700, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  187, 0x2300, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  188, 0x2f00, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  189, 0x3a00, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  190, 0x4600, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  191, 0x5100, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  192, 0x5d00, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  193, 0x6900, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  194, 0x7400, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  195, 0x8000, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  196, 0x8000, 0x0000, 0x7400);
                 ezfb_set_cmap_index(fb,  197, 0x8000, 0x0000, 0x6900);
                 ezfb_set_cmap_index(fb,  198, 0x8000, 0x0000, 0x5d00);
                 ezfb_set_cmap_index(fb,  199, 0x8000, 0x0000, 0x5100);
                 ezfb_set_cmap_index(fb,  200, 0x8000, 0x0000, 0x4600);
                 ezfb_set_cmap_index(fb,  201, 0x8000, 0x0000, 0x3a00);
                 ezfb_set_cmap_index(fb,  202, 0x8000, 0x0000, 0x2f00);
                 ezfb_set_cmap_index(fb,  203, 0x8000, 0x0000, 0x2300);
                 ezfb_set_cmap_index(fb,  204, 0x8000, 0x0000, 0x1700);
                 ezfb_set_cmap_index(fb,  205, 0x8000, 0x0000, 0x0c00);
                 ezfb_set_cmap_index(fb,  206, 0xff00, 0xc000, 0xc000);
                 ezfb_set_cmap_index(fb,  207, 0xff00, 0x4000, 0x4000);
                 ezfb_set_cmap_index(fb,  208, 0xc000, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,  209, 0x4000, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,  210, 0xff00, 0xff00, 0xc000);
                 ezfb_set_cmap_index(fb,  211, 0xff00, 0xff00, 0x4000);
                 ezfb_set_cmap_index(fb,  212, 0xc000, 0xc000, 0x0000);
                 ezfb_set_cmap_index(fb,  213, 0x4000, 0x4000, 0x0000);
                 ezfb_set_cmap_index(fb,  214, 0xc000, 0xff00, 0xc000);
                 ezfb_set_cmap_index(fb,  215, 0x4000, 0xff00, 0x4000);
                 ezfb_set_cmap_index(fb,  216, 0x0000, 0xc000, 0x0000);
                 ezfb_set_cmap_index(fb,  217, 0x0000, 0x4000, 0x0000);
                 ezfb_set_cmap_index(fb,  218, 0xc000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,  219, 0x4000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,  220, 0x0000, 0xc000, 0xc000);
                 ezfb_set_cmap_index(fb,  221, 0x0000, 0x4000, 0x4000);
                 ezfb_set_cmap_index(fb,  222, 0xc000, 0xc000, 0xff00);
                 ezfb_set_cmap_index(fb,  223, 0x4000, 0x4000, 0xff00);
                 ezfb_set_cmap_index(fb,  224, 0x0000, 0x0000, 0xc000);
                 ezfb_set_cmap_index(fb,  225, 0x0000, 0x0000, 0x4000);
                 ezfb_set_cmap_index(fb,  226, 0xff00, 0xc000, 0xff00);
                 ezfb_set_cmap_index(fb,  227, 0xff00, 0x4000, 0xff00);
                 ezfb_set_cmap_index(fb,  228, 0xc000, 0x0000, 0xc000);
                 ezfb_set_cmap_index(fb,  229, 0x4000, 0x0000, 0x4000);
                 ezfb_set_cmap_index(fb,  230, 0xff00, 0x6000, 0x6000);
                 ezfb_set_cmap_index(fb,  231, 0xff00, 0xff00, 0xff00); // white
                 ezfb_set_cmap_index(fb,  232, 0xf500, 0xf500, 0xf500);
                 ezfb_set_cmap_index(fb,  233, 0xeb00, 0xeb00, 0xeb00);
                 ezfb_set_cmap_index(fb,  234, 0xe000, 0xe000, 0xe000);
                 ezfb_set_cmap_index(fb,  235, 0xd500, 0xd500, 0xd500);
                 ezfb_set_cmap_index(fb,  236, 0xcb00, 0xcb00, 0xcb00);
                 ezfb_set_cmap_index(fb,  237, 0xc000, 0xc000, 0xc000);
                 ezfb_set_cmap_index(fb,  238, 0xb500, 0xb500, 0xb500);
                 ezfb_set_cmap_index(fb,  239, 0xab00, 0xab00, 0xab00);
                 ezfb_set_cmap_index(fb,  240, 0xa000, 0xa000, 0xa000);
                 ezfb_set_cmap_index(fb,  241, 0x9500, 0x9500, 0x9500);
                 ezfb_set_cmap_index(fb,  242, 0x8b00, 0x8b00, 0x8b00);
                 ezfb_set_cmap_index(fb,  243, 0x8000, 0x8000, 0x8000);
                 ezfb_set_cmap_index(fb,  244, 0x7500, 0x7500, 0x7500);
                 ezfb_set_cmap_index(fb,  245, 0x6b00, 0x6b00, 0x6b00);
                 ezfb_set_cmap_index(fb,  246, 0x6000, 0x6000, 0x6000);
                 ezfb_set_cmap_index(fb,  247, 0x5500, 0x5500, 0x5500);
                 ezfb_set_cmap_index(fb,  248, 0x4b00, 0x4b00, 0x4b00);
                 ezfb_set_cmap_index(fb,  249, 0x4000, 0x4000, 0x4000);
                 ezfb_set_cmap_index(fb,  250, 0x3500, 0x3500, 0x3500);
                 ezfb_set_cmap_index(fb,  251, 0x2b00, 0x2b00, 0x2b00);
                 ezfb_set_cmap_index(fb,  252, 0x2000, 0x2000, 0x2000);
                 ezfb_set_cmap_index(fb,  253, 0x1500, 0x1500, 0x1500);
                 ezfb_set_cmap_index(fb,  254, 0x0b00, 0x0b00, 0x0b00);
                 ezfb_set_cmap_index(fb,  255, 0x0000, 0x0000, 0x0000); // black
                 break;
        //--------------------------------------------------------------------
    }
    if(fb->colors.exists && (fb->Var.bits_per_pixel <= 8))
    {
        ret =  ezfb_set_cmap(fb);
        ret &= ezfb_find_black_and_white(fb);
    }
EZFB_FUNCTION_RETURN(ret)
}

//############################################################################
int ezfb_set_cmap_x29(struct ezfb* fb)
{
    u_int i;
EZFB_FUNCTION_CALL_0
    switch(fb->Var.bits_per_pixel)
    {
        case  1: ezfb_set_cmap_index(fb, 0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb, 1, 0xffff, 0xffff, 0xffff); // white
                 break;
        //--------------------------------------------------------------------
        case  2: ezfb_set_cmap_index(fb, 0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb, 1, 0xffff, 0x0000, 0xffff); // magenta
                 ezfb_set_cmap_index(fb, 2, 0x0000, 0xffff, 0xffff); // cyan
                 ezfb_set_cmap_index(fb, 3, 0xffff, 0xffff, 0xffff); // white
                 break;
        //--------------------------------------------------------------------
        case  4: ezfb_set_cmap_index(fb,    0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb,    1, 0x0000, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    2, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    3, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    4, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    5, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    6, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    7, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    8, 0x8000, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,    9, 0x8000, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,   10, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   11, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   12, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   13, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   14, 0xff00, 0xff00, 0xff00); // white
                 ezfb_set_cmap_index(fb,   15, 0xff00, 0xff00, 0xff00);
                 break;
        //--------------------------------------------------------------------
        case  8:
        case 15:
        case 16:
        case 24:
        case 32: ezfb_set_cmap_index(fb,    0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb,    1, 0x0000, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    2, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    3, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    4, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    5, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    6, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    7, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    8, 0x8000, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,    9, 0x8000, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,   10, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   11, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   12, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   13, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,   14, 0xff00, 0xff00, 0xff00); // white
                 ezfb_set_cmap_index(fb,   15, 0xff00, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,   16, 0x0000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,   17, 0x0000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,   18, 0x0000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,   19, 0x0000, 0xff00, 0xff00); //last unique

                 for(i = 20; i < 255; i++)
                    ezfb_set_cmap_index(fb, i, 0x0000, 0x0000, 0x0000);
                 break;
        //--------------------------------------------------------------------
    }
    if(fb->colors.exists && (fb->Var.bits_per_pixel <= 8))
    {
        ret =  ezfb_set_cmap(fb);
        ret &= ezfb_find_black_and_white(fb);
    }
EZFB_FUNCTION_RETURN(ret)
}

//############################################################################
int ezfb_set_cmap_ilda_standard(struct ezfb* fb)
{
EZFB_FUNCTION_CALL_0
    switch(fb->Var.bits_per_pixel)
    {
        case  1: ezfb_set_cmap_index(fb, 0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb, 1, 0xffff, 0xffff, 0xffff); // white
                 break;
        //--------------------------------------------------------------------
        case  2: ezfb_set_cmap_index(fb, 0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb, 1, 0xffff, 0x0000, 0xffff); // magenta
                 ezfb_set_cmap_index(fb, 2, 0x0000, 0xffff, 0xffff); // cyan
                 ezfb_set_cmap_index(fb, 3, 0xffff, 0xffff, 0xffff); // white
                 break;
        //--------------------------------------------------------------------
        case  4: ezfb_set_cmap_index(fb,    0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb,    1, 0xff00, 0xff00, 0xff00); // white
                 ezfb_set_cmap_index(fb,    2, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    3, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    4, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    5, 0x0000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,    6, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,    7, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,    8, 0xff00, 0x8000, 0x8000);
                 ezfb_set_cmap_index(fb,    9, 0xff00, 0x8c00, 0x8000);
                 ezfb_set_cmap_index(fb,   10, 0xff00, 0x9700, 0x8000);
                 ezfb_set_cmap_index(fb,   11, 0xff00, 0xa300, 0x8000);
                 ezfb_set_cmap_index(fb,   12, 0xff00, 0xae00, 0x8000);
                 ezfb_set_cmap_index(fb,   13, 0xff00, 0xba00, 0x8000);
                 ezfb_set_cmap_index(fb,   14, 0xff00, 0xc500, 0x8000);
                 ezfb_set_cmap_index(fb,   15, 0xff00, 0xd100, 0x8000);
                 break;
        //--------------------------------------------------------------------
        case  8:
        case 15:
        case 16:
        case 24:
        case 32: ezfb_set_cmap_index(fb,    0, 0x0000, 0x0000, 0x0000); // black
                 ezfb_set_cmap_index(fb,    1, 0xff00, 0xff00, 0xff00); // white
                 ezfb_set_cmap_index(fb,    2, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,    3, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    4, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,    5, 0x0000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,    6, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,    7, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,    8, 0xff00, 0x8000, 0x8000);
                 ezfb_set_cmap_index(fb,    9, 0xff00, 0x8c00, 0x8000);
                 ezfb_set_cmap_index(fb,   10, 0xff00, 0x9700, 0x8000);
                 ezfb_set_cmap_index(fb,   11, 0xff00, 0xa300, 0x8000);
                 ezfb_set_cmap_index(fb,   12, 0xff00, 0xae00, 0x8000);
                 ezfb_set_cmap_index(fb,   13, 0xff00, 0xba00, 0x8000);
                 ezfb_set_cmap_index(fb,   14, 0xff00, 0xc500, 0x8000);
                 ezfb_set_cmap_index(fb,   15, 0xff00, 0xd100, 0x8000);
                 ezfb_set_cmap_index(fb,   16, 0xff00, 0xdc00, 0x8000);
                 ezfb_set_cmap_index(fb,   17, 0xff00, 0xe800, 0x8000);
                 ezfb_set_cmap_index(fb,   18, 0xff00, 0xf300, 0x8000);
                 ezfb_set_cmap_index(fb,   19, 0xff00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   20, 0xf300, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   21, 0xe800, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   22, 0xdc00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   23, 0xd100, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   24, 0xc500, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   25, 0xba00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   26, 0xae00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   27, 0xa300, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   28, 0x9700, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   29, 0x8c00, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   30, 0x8000, 0xff00, 0x8000);
                 ezfb_set_cmap_index(fb,   31, 0x8000, 0xff00, 0x8c00);
                 ezfb_set_cmap_index(fb,   32, 0x8000, 0xff00, 0x9700);
                 ezfb_set_cmap_index(fb,   33, 0x8000, 0xff00, 0xa300);
                 ezfb_set_cmap_index(fb,   34, 0x8000, 0xff00, 0xae00);
                 ezfb_set_cmap_index(fb,   35, 0x8000, 0xff00, 0xba00);
                 ezfb_set_cmap_index(fb,   36, 0x8000, 0xff00, 0xc500);
                 ezfb_set_cmap_index(fb,   37, 0x8000, 0xff00, 0xd100);
                 ezfb_set_cmap_index(fb,   38, 0x8000, 0xff00, 0xdc00);
                 ezfb_set_cmap_index(fb,   39, 0x8000, 0xff00, 0xe800);
                 ezfb_set_cmap_index(fb,   40, 0x8000, 0xff00, 0xf300);
                 ezfb_set_cmap_index(fb,   41, 0x8000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,   42, 0x8000, 0xf300, 0xff00);
                 ezfb_set_cmap_index(fb,   43, 0x8000, 0xe800, 0xff00);
                 ezfb_set_cmap_index(fb,   44, 0x8000, 0xdc00, 0xff00);
                 ezfb_set_cmap_index(fb,   45, 0x8000, 0xd100, 0xff00);
                 ezfb_set_cmap_index(fb,   46, 0x8000, 0xc500, 0xff00);
                 ezfb_set_cmap_index(fb,   47, 0x8000, 0xba00, 0xff00);
                 ezfb_set_cmap_index(fb,   48, 0x8000, 0xae00, 0xff00);
                 ezfb_set_cmap_index(fb,   49, 0x8000, 0xa300, 0xff00);
                 ezfb_set_cmap_index(fb,   50, 0x8000, 0x9700, 0xff00);
                 ezfb_set_cmap_index(fb,   51, 0x8000, 0x8c00, 0xff00);
                 ezfb_set_cmap_index(fb,   52, 0x8000, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   53, 0x8c00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   54, 0x9700, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   55, 0xa300, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   56, 0xae00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   57, 0xba00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   58, 0xc500, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   59, 0xd100, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   60, 0xdc00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   61, 0xe800, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   62, 0xf300, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   63, 0xff00, 0x8000, 0xff00);
                 ezfb_set_cmap_index(fb,   64, 0xff00, 0x8000, 0xf300);
                 ezfb_set_cmap_index(fb,   65, 0xff00, 0x8000, 0xe800);
                 ezfb_set_cmap_index(fb,   66, 0xff00, 0x8000, 0xdc00);
                 ezfb_set_cmap_index(fb,   67, 0xff00, 0x8000, 0xd100);
                 ezfb_set_cmap_index(fb,   68, 0xff00, 0x8000, 0xc500);
                 ezfb_set_cmap_index(fb,   69, 0xff00, 0x8000, 0xba00);
                 ezfb_set_cmap_index(fb,   70, 0xff00, 0x8000, 0xae00);
                 ezfb_set_cmap_index(fb,   71, 0xff00, 0x8000, 0xa300);
                 ezfb_set_cmap_index(fb,   72, 0xff00, 0x8000, 0x9700);
                 ezfb_set_cmap_index(fb,   73, 0xff00, 0x8000, 0x8c00);
                 ezfb_set_cmap_index(fb,   74, 0xff00, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,   75, 0xff00, 0x1700, 0x0000);
                 ezfb_set_cmap_index(fb,   76, 0xff00, 0x2e00, 0x0000);
                 ezfb_set_cmap_index(fb,   77, 0xff00, 0x4600, 0x0000);
                 ezfb_set_cmap_index(fb,   78, 0xff00, 0x5d00, 0x0000);
                 ezfb_set_cmap_index(fb,   79, 0xff00, 0x7400, 0x0000);
                 ezfb_set_cmap_index(fb,   80, 0xff00, 0x8b00, 0x0000);
                 ezfb_set_cmap_index(fb,   81, 0xff00, 0xa200, 0x0000);
                 ezfb_set_cmap_index(fb,   82, 0xff00, 0xb900, 0x0000);
                 ezfb_set_cmap_index(fb,   83, 0xff00, 0xd100, 0x0000);
                 ezfb_set_cmap_index(fb,   84, 0xff00, 0xe800, 0x0000);
                 ezfb_set_cmap_index(fb,   85, 0xff00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   86, 0xe800, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   87, 0xd100, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   88, 0xb900, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   89, 0xa200, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   90, 0x8b00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   91, 0x7400, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   92, 0x5d00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   93, 0x4600, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   94, 0x2e00, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   95, 0x1700, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   96, 0x0000, 0xff00, 0x0000);
                 ezfb_set_cmap_index(fb,   97, 0x0000, 0xff00, 0x1700);
                 ezfb_set_cmap_index(fb,   98, 0x0000, 0xff00, 0x2e00);
                 ezfb_set_cmap_index(fb,   99, 0x0000, 0xff00, 0x4600);
                 ezfb_set_cmap_index(fb,  100, 0x0000, 0xff00, 0x5d00);
                 ezfb_set_cmap_index(fb,  101, 0x0000, 0xff00, 0x7400);
                 ezfb_set_cmap_index(fb,  102, 0x0000, 0xff00, 0x8b00);
                 ezfb_set_cmap_index(fb,  103, 0x0000, 0xff00, 0xa200);
                 ezfb_set_cmap_index(fb,  104, 0x0000, 0xff00, 0xb900);
                 ezfb_set_cmap_index(fb,  105, 0x0000, 0xff00, 0xd100);
                 ezfb_set_cmap_index(fb,  106, 0x0000, 0xff00, 0xe800);
                 ezfb_set_cmap_index(fb,  107, 0x0000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,  108, 0x0000, 0xe800, 0xff00);
                 ezfb_set_cmap_index(fb,  109, 0x0000, 0xd100, 0xff00);
                 ezfb_set_cmap_index(fb,  110, 0x0000, 0xb900, 0xff00);
                 ezfb_set_cmap_index(fb,  111, 0x0000, 0xa200, 0xff00);
                 ezfb_set_cmap_index(fb,  112, 0x0000, 0x8b00, 0xff00);
                 ezfb_set_cmap_index(fb,  113, 0x0000, 0x7400, 0xff00);
                 ezfb_set_cmap_index(fb,  114, 0x0000, 0x5d00, 0xff00);
                 ezfb_set_cmap_index(fb,  115, 0x0000, 0x4600, 0xff00);
                 ezfb_set_cmap_index(fb,  116, 0x0000, 0x2e00, 0xff00);
                 ezfb_set_cmap_index(fb,  117, 0x0000, 0x1700, 0xff00);
                 ezfb_set_cmap_index(fb,  118, 0x0000, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  119, 0x1700, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  120, 0x2e00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  121, 0x4600, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  122, 0x5d00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  123, 0x7400, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  124, 0x8b00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  125, 0xa200, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  126, 0xb900, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  127, 0xd100, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  128, 0xe800, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  129, 0xff00, 0x0000, 0xff00);
                 ezfb_set_cmap_index(fb,  130, 0xff00, 0x0000, 0xe800);
                 ezfb_set_cmap_index(fb,  131, 0xff00, 0x0000, 0xd100);
                 ezfb_set_cmap_index(fb,  132, 0xff00, 0x0000, 0xb900);
                 ezfb_set_cmap_index(fb,  133, 0xff00, 0x0000, 0xa200);
                 ezfb_set_cmap_index(fb,  134, 0xff00, 0x0000, 0x8b00);
                 ezfb_set_cmap_index(fb,  135, 0xff00, 0x0000, 0x7400);
                 ezfb_set_cmap_index(fb,  136, 0xff00, 0x0000, 0x5d00);
                 ezfb_set_cmap_index(fb,  137, 0xff00, 0x0000, 0x4600);
                 ezfb_set_cmap_index(fb,  138, 0xff00, 0x0000, 0x2e00);
                 ezfb_set_cmap_index(fb,  139, 0xff00, 0x0000, 0x1700);
                 ezfb_set_cmap_index(fb,  140, 0x8000, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,  141, 0x8000, 0x0c00, 0x0000);
                 ezfb_set_cmap_index(fb,  142, 0x8000, 0x1700, 0x0000);
                 ezfb_set_cmap_index(fb,  143, 0x8000, 0x2300, 0x0000);
                 ezfb_set_cmap_index(fb,  144, 0x8000, 0x2f00, 0x0000);
                 ezfb_set_cmap_index(fb,  145, 0x8000, 0x3a00, 0x0000);
                 ezfb_set_cmap_index(fb,  146, 0x8000, 0x4600, 0x0000);
                 ezfb_set_cmap_index(fb,  147, 0x8000, 0x5100, 0x0000);
                 ezfb_set_cmap_index(fb,  148, 0x8000, 0x5d00, 0x0000);
                 ezfb_set_cmap_index(fb,  149, 0x8000, 0x6900, 0x0000);
                 ezfb_set_cmap_index(fb,  150, 0x8000, 0x7400, 0x0000);
                 ezfb_set_cmap_index(fb,  151, 0x8000, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  152, 0x7400, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  153, 0x6900, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  154, 0x5d00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  155, 0x5100, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  156, 0x4600, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  157, 0x3a00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  158, 0x2f00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  159, 0x2300, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  160, 0x1700, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  161, 0x0c00, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  162, 0x0000, 0x8000, 0x0000);
                 ezfb_set_cmap_index(fb,  163, 0x0000, 0x8000, 0x0c00);
                 ezfb_set_cmap_index(fb,  164, 0x0000, 0x8000, 0x1700);
                 ezfb_set_cmap_index(fb,  165, 0x0000, 0x8000, 0x2300);
                 ezfb_set_cmap_index(fb,  166, 0x0000, 0x8000, 0x2f00);
                 ezfb_set_cmap_index(fb,  167, 0x0000, 0x8000, 0x3a00);
                 ezfb_set_cmap_index(fb,  168, 0x0000, 0x8000, 0x4600);
                 ezfb_set_cmap_index(fb,  169, 0x0000, 0x8000, 0x5100);
                 ezfb_set_cmap_index(fb,  170, 0x0000, 0x8000, 0x5d00);
                 ezfb_set_cmap_index(fb,  171, 0x0000, 0x8000, 0x6900);
                 ezfb_set_cmap_index(fb,  172, 0x0000, 0x8000, 0x7400);
                 ezfb_set_cmap_index(fb,  173, 0x0000, 0x8000, 0x8000);
                 ezfb_set_cmap_index(fb,  174, 0x0000, 0x7400, 0x8000);
                 ezfb_set_cmap_index(fb,  175, 0x0000, 0x6900, 0x8000);
                 ezfb_set_cmap_index(fb,  176, 0x0000, 0x5d00, 0x8000);
                 ezfb_set_cmap_index(fb,  177, 0x0000, 0x5100, 0x8000);
                 ezfb_set_cmap_index(fb,  178, 0x0000, 0x4600, 0x8000);
                 ezfb_set_cmap_index(fb,  179, 0x0000, 0x3a00, 0x8000);
                 ezfb_set_cmap_index(fb,  180, 0x0000, 0x2f00, 0x8000);
                 ezfb_set_cmap_index(fb,  181, 0x0000, 0x2300, 0x8000);
                 ezfb_set_cmap_index(fb,  182, 0x0000, 0x1700, 0x8000);
                 ezfb_set_cmap_index(fb,  183, 0x0000, 0x0c00, 0x8000);
                 ezfb_set_cmap_index(fb,  184, 0x0000, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  185, 0x0c00, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  186, 0x1700, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  187, 0x2300, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  188, 0x2f00, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  189, 0x3a00, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  190, 0x4600, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  191, 0x5100, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  192, 0x5d00, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  193, 0x6900, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  194, 0x7400, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  195, 0x8000, 0x0000, 0x8000);
                 ezfb_set_cmap_index(fb,  196, 0x8000, 0x0000, 0x7400);
                 ezfb_set_cmap_index(fb,  197, 0x8000, 0x0000, 0x6900);
                 ezfb_set_cmap_index(fb,  198, 0x8000, 0x0000, 0x5d00);
                 ezfb_set_cmap_index(fb,  199, 0x8000, 0x0000, 0x5100);
                 ezfb_set_cmap_index(fb,  200, 0x8000, 0x0000, 0x4600);
                 ezfb_set_cmap_index(fb,  201, 0x8000, 0x0000, 0x3a00);
                 ezfb_set_cmap_index(fb,  202, 0x8000, 0x0000, 0x2f00);
                 ezfb_set_cmap_index(fb,  203, 0x8000, 0x0000, 0x2300);
                 ezfb_set_cmap_index(fb,  204, 0x8000, 0x0000, 0x1700);
                 ezfb_set_cmap_index(fb,  205, 0x8000, 0x0000, 0x0c00);
                 ezfb_set_cmap_index(fb,  206, 0xff00, 0xc000, 0xc000);
                 ezfb_set_cmap_index(fb,  207, 0xff00, 0x4000, 0x4000);
                 ezfb_set_cmap_index(fb,  208, 0xc000, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,  209, 0x4000, 0x0000, 0x0000);
                 ezfb_set_cmap_index(fb,  210, 0xff00, 0xff00, 0xc000);
                 ezfb_set_cmap_index(fb,  211, 0xff00, 0xff00, 0x4000);
                 ezfb_set_cmap_index(fb,  212, 0xc000, 0xc000, 0x0000);
                 ezfb_set_cmap_index(fb,  213, 0x4000, 0x4000, 0x0000);
                 ezfb_set_cmap_index(fb,  214, 0xc000, 0xff00, 0xc000);
                 ezfb_set_cmap_index(fb,  215, 0x4000, 0xff00, 0x4000);
                 ezfb_set_cmap_index(fb,  216, 0x0000, 0xc000, 0x0000);
                 ezfb_set_cmap_index(fb,  217, 0x0000, 0x4000, 0x0000);
                 ezfb_set_cmap_index(fb,  218, 0xc000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,  219, 0x4000, 0xff00, 0xff00);
                 ezfb_set_cmap_index(fb,  220, 0x0000, 0xc000, 0xc000);
                 ezfb_set_cmap_index(fb,  221, 0x0000, 0x4000, 0x4000);
                 ezfb_set_cmap_index(fb,  222, 0xc000, 0xc000, 0xff00);
                 ezfb_set_cmap_index(fb,  223, 0x4000, 0x4000, 0xff00);
                 ezfb_set_cmap_index(fb,  224, 0x0000, 0x0000, 0xc000);
                 ezfb_set_cmap_index(fb,  225, 0x0000, 0x0000, 0x4000);
                 ezfb_set_cmap_index(fb,  226, 0xff00, 0xc000, 0xff00);
                 ezfb_set_cmap_index(fb,  227, 0xff00, 0x4000, 0xff00);
                 ezfb_set_cmap_index(fb,  228, 0xc000, 0x0000, 0xc000);
                 ezfb_set_cmap_index(fb,  229, 0x4000, 0x0000, 0x4000);
                 ezfb_set_cmap_index(fb,  230, 0xff00, 0x6000, 0x6000);
                 ezfb_set_cmap_index(fb,  231, 0xff00, 0xff00, 0xff00); // white
                 ezfb_set_cmap_index(fb,  232, 0xf500, 0xf500, 0xf500);
                 ezfb_set_cmap_index(fb,  233, 0xeb00, 0xeb00, 0xeb00);
                 ezfb_set_cmap_index(fb,  234, 0xe000, 0xe000, 0xe000);
                 ezfb_set_cmap_index(fb,  235, 0xd500, 0xd500, 0xd500);
                 ezfb_set_cmap_index(fb,  236, 0xcb00, 0xcb00, 0xcb00);
                 ezfb_set_cmap_index(fb,  237, 0xc000, 0xc000, 0xc000);
                 ezfb_set_cmap_index(fb,  238, 0xb500, 0xb500, 0xb500);
                 ezfb_set_cmap_index(fb,  239, 0xab00, 0xab00, 0xab00);
                 ezfb_set_cmap_index(fb,  240, 0xa000, 0xa000, 0xa000);
                 ezfb_set_cmap_index(fb,  241, 0x9500, 0x9500, 0x9500);
                 ezfb_set_cmap_index(fb,  242, 0x8b00, 0x8b00, 0x8b00);
                 ezfb_set_cmap_index(fb,  243, 0x8000, 0x8000, 0x8000);
                 ezfb_set_cmap_index(fb,  244, 0x7500, 0x7500, 0x7500);
                 ezfb_set_cmap_index(fb,  245, 0x6b00, 0x6b00, 0x6b00);
                 ezfb_set_cmap_index(fb,  246, 0x6000, 0x6000, 0x6000);
                 ezfb_set_cmap_index(fb,  247, 0x5500, 0x5500, 0x5500);
                 ezfb_set_cmap_index(fb,  248, 0x4b00, 0x4b00, 0x4b00);
                 ezfb_set_cmap_index(fb,  249, 0x4000, 0x4000, 0x4000);
                 ezfb_set_cmap_index(fb,  250, 0x3500, 0x3500, 0x3500);
                 ezfb_set_cmap_index(fb,  251, 0x2b00, 0x2b00, 0x2b00);
                 ezfb_set_cmap_index(fb,  252, 0x2000, 0x2000, 0x2000);
                 ezfb_set_cmap_index(fb,  253, 0x1500, 0x1500, 0x1500);
                 ezfb_set_cmap_index(fb,  254, 0x0b00, 0x0b00, 0x0b00);
                 ezfb_set_cmap_index(fb,  255, 0x0000, 0x0000, 0x0000); // black
                 break;
    //------------------------------------------------------------------------
    }
    if(fb->colors.exists && (fb->Var.bits_per_pixel <= 8))
    {
        ret =  ezfb_set_cmap(fb);
        ret &= ezfb_find_black_and_white(fb);
    }
EZFB_FUNCTION_RETURN(ret)
}

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################
