//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#ifndef __EZFB_MACRO_DEFINITIONS__
#define __EZFB_MACRO_DEFINITIONS__

//############################################################################
#define EZFB_API_ERRORS                      1
#define EZFB_API_MESSAGES                    1
#define EZFB_API_FUNCTION_TRACING            0
#define EZFB_API_FUNCTION_NIT_PICKING        0

#if     EZFB_API_FUNCTION_TRACING
#define EZFB_FUNCTION_CALL         printf(" call --------------------------> %s\n",__FUNCTION__);fflush(stdout);
#define EZFB_FUNCTION_CALL_1       int ret = 1; EZFB_FUNCTION_CALL
#define EZFB_FUNCTION_CALL_0       int ret = 0; EZFB_FUNCTION_CALL
// NOTE: Do not use a function call as an arguments to this macro. It will be called twice !!!
#define EZFB_FUNCTION_PRERETURN    printf("%s <-- %s\n","end" ,__FUNCTION__);fflush(stdout);
#define EZFB_FUNCTION_RETURN(ret)  printf("%s <-- %s\n",((ret)?("PASSED"):("\nXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\nFAILED")),__FUNCTION__);fflush(stdout);return(ret);
#define EZFB_FUNCTION_RETURN_      printf("%s <-- %s\n","PASSED" ,__FUNCTION__);fflush(stdout);return;
#else
#define EZFB_FUNCTION_CALL
#define EZFB_FUNCTION_CALL_1       int ret = 1;
#define EZFB_FUNCTION_CALL_0       int ret = 0;
#define EZFB_FUNCTION_PRERETURN    
#define EZFB_FUNCTION_RETURN(ret)  return(ret);
#define EZFB_FUNCTION_RETURN_      return;
#endif

#if     EZFB_API_FUNCTION_NIT_PICKING
#define EZFB_NIT_PICKING_FUNCTION_CALL         printf(" call --------------------------> %s\n",__FUNCTION__);fflush(stdout);
#define EZFB_NIT_PICKING_FUNCTION_CALL_1       int ret = 1; EZFB_NIT_PICKING_FUNCTION_CALL
#define EZFB_NIT_PICKING_FUNCTION_CALL_0       int ret = 0; EZFB_NIT_PICKING_FUNCTION_CALL
// NOTE: Do not use a function call as an arguments to this macro. It will be called twice !!!
#define EZFB_NIT_PICKING_FUNCTION_RETURN(ret)  printf("%s <-- %s\n",((ret)?("PASSED"):("\nXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\nFAILED")),__FUNCTION__);fflush(stdout);return(ret);
#define EZFB_NIT_PICKING_FUNCTION_RETURN_      printf("%s <-- %s\n","PASSED" ,__FUNCTION__);fflush(stdout);return;
#else
#define EZFB_NIT_PICKING_FUNCTION_CALL
#define EZFB_NIT_PICKING_FUNCTION_CALL_1       int ret = 1;
#define EZFB_NIT_PICKING_FUNCTION_CALL_0       int ret = 0;
#define EZFB_NIT_PICKING_FUNCTION_RETURN(ret)  return(ret);
#define EZFB_NIT_PICKING_FUNCTION_RETURN_      return;
#endif

//############################################################################
#define EZFB_TTY_DEVICE                 "/dev/tty0"
#define EZFB_DEV_NAME                   "/dev/fb" // "/dev/fb/31"
#define EZFB_MAX_NAME_LENGTH            11
#define EZFB_MAX_FB_NUM                 31
#define EZFB_BMP_FILE_HEADER_SIZE       54
#define EZFB_BITS_IN_SHORT              16
#define EZFB_BITS_IN_CHAR                8
#define EZFB_WAIT_4_KEY_USECS         5000
#define EZFB_GET_KEY_USECS            5000
//############################################################################
#endif

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################
