//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#ifndef __EZFB_PIXEL_DRAWING_FUNCTIONS__
#define __EZFB_PIXEL_DRAWING_FUNCTIONS__

//############################################################################

#include "ezfb_types.h"

//############################################################################
int      ezfb_put_pixel         (struct ezfb* fb, u_int  x, u_int  y, u_int   c);
int      ezfb_put_r_in_pixel    (struct ezfb* fb, u_int  x, u_int  y, u_short r);
int      ezfb_put_g_in_pixel    (struct ezfb* fb, u_int  x, u_int  y, u_short r);
int      ezfb_put_b_in_pixel    (struct ezfb* fb, u_int  x, u_int  y, u_short r);
u_int    ezfb_get_pixel         (struct ezfb* fb, u_int  x, u_int  y);
u_short  ezfb_get_r_from_pixel  (struct ezfb* fb, u_int  x, u_int  y);
u_short  ezfb_get_g_from_pixel  (struct ezfb* fb, u_int  x, u_int  y);
u_short  ezfb_get_b_from_pixel  (struct ezfb* fb, u_int  x, u_int  y);
int      ezfb_put_line          (struct ezfb* fb, int x1, int y1, int  x2, int  y2, int c);
int      ezfb_put_ray           (struct ezfb* fb, int  x, int  y, float r, float t, int c);
int      ezfb_put_rectangle     (struct ezfb* fb, int x1, int y1, int  x2, int  y2, int c, int filled);

//############################################################################
#endif

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################

