//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#ifndef __EZFB_TTY_SWITCH_FUNCTIONS__
#define __EZFB_TTY_SWITCH_FUNCTIONS__

//############################################################################

#include "ezfb_types.h"

//############################################################################
#define EZFB_ARROW_UP              0x415b1b
#define EZFB_ARROW_DOWN            0x425b1b
#define EZFB_ARROW_RIGHT           0x435b1b
#define EZFB_ARROW_LEFT            0x445b1b
#define EZFB_ESCAPE_KEY            0x1b
#define EZFB_F1_KEY                0x504f1b
#define EZFB_F2_KEY                0x514f1b
#define EZFB_F3_KEY                0x524f1b
#define EZFB_F4_KEY                0x534f1b
#define EZFB_DELETE_KEY            0x7f
#define EZFB_CTRL_A                0x1
#define EZFB_CTRL_B                0x2
// #define EZFB_CTRL_C ezfb_terminateS PROGRAM
#define EZFB_CTRL_D                0x4
#define EZFB_CTRL_E                0x5
#define EZFB_CTRL_F                0x6
#define EZFB_CTRL_G                0x7
#define EZFB_CTRL_H                0x8
#define EZFB_BACKSPACE_KEY         0x8
#define EZFB_CTRL_I                0x9
#define EZFB_TAB_KEY               0x9
#define EZFB_CTRL_J                0xa
#define EZFB_ENTER_KEY             0xa
#define EZFB_CTRL_K                0xb
#define EZFB_CTRL_L                0xc
#define EZFB_CTRL_M                0xd
#define EZFB_CTRL_N                0xe
#define EZFB_CTRL_O                0xf
#define EZFB_CTRL_P                0x10
//#define EZFB_CTRL_Q DOES NOTHING
#define EZFB_CTRL_R                0x12
//#define EZFB_CTRL_S SCREWS UP THE CONSOLE
#define EZFB_CTRL_T                0x14
#define EZFB_CTRL_U                0x15
#define EZFB_CTRL_V                0x16
#define EZFB_CTRL_W                0x17
#define EZFB_CTRL_X                0x18
#define EZFB_CTRL_Y                0x19
//#define EZFB_CTRL_Z SUSPENDS THE PROGRAM

//############################################################################
int   ezfb_tty_graphics  ();
int   ezfb_tty_text      ();
void  ezfb_restore_input ();
int   ezfb_set_input_hot ();
char  ezfb_kb_hit        ();
int   ezfb_wait_4_key    ();
int   ezfb_get_key       ();
int   ezfb_get_dec_int   ();
int   ezfb_get_chars     (char* line);
//############################################################################
#endif

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################



