//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#ifndef __EZFB_NEW_TYPE_DEFINITIONS__
#define __EZFB_NEW_TYPE_DEFINITIONS__

//############################################################################

#include "ezfb_includes.h"
#include "ezfb_macros.h"

//############################################################################
struct ezfb_colors
{
               u_int                exists                   ;
               u_int                old_was_saved            ;
    struct     fb_cmap              fbcmap                   ;
               u_int                white                    ;
               u_int                black                    ;
               u_int                bit_mask_red             ;
               u_int                bit_mask_green           ;
               u_int                bit_mask_blue            ;
               u_int                offset_plus_length_red   ;
               u_int                offset_plus_length_green ;
               u_int                offset_plus_length_blue  ;
               u_int                shortest_color           ;
               u_short              red                [256] ;
               u_short              green              [256] ;
               u_short              blue               [256] ;
               u_short              red_was            [256] ;
               u_short              green_was          [256] ;
               u_short              blue_was           [256] ;
};

//############################################################################
struct ezfb
{
               int                  fd                             ;
               u_int                dev_num                        ;
               char                 dev_name[EZFB_MAX_NAME_LENGTH] ;
    struct     fb_fix_screeninfo    Fix                            ;
    struct     fb_var_screeninfo    Var                            ;
    struct     ezfb_colors          colors                         ;
               u_int                exists                         ;
               u_int                resolution_changed             ;
               u_int                bpp_was_changed                ;
               u_int                xres_was                       ;
               u_int                yres_was                       ;
               u_int                xres_virtual_was               ;
               u_int                yres_virtual_was               ;
               u_int                xoffset_was                    ;
               u_int                yoffset_was                    ;
               u_int                bpp_was                        ;
    volatile   u_char*              data                           ;
    volatile   u_char*              screen_uchars                  ;
    volatile   u_short*             screen_ushorts                 ;
    volatile   u_int*               screen_uints                   ;
               u_char*              data_was                       ;
               u_int                max_x                          ;
               u_int                max_y                          ;
               u_int                mid_x                          ;
               u_int                mid_y                          ;
};

//############################################################################
struct ezfb_bitmap
{                                //  defaults     offset
    char       B               ; //  'B'          0 :
    char       M               ; //  'M'          1 :
    u_int      file_size       ; //               2 :
    int        reserved        ; //  0            6 :
    int        jump            ; //              10 : offset to pixel data
    int        to_end          ; //  40          14 : from here to end of header
    u_int      xres            ; //              18 :
    u_int      yres            ; //              22 :
    u_short    planes          ; //  1           26 :
    u_short    bpp             ; //              28 : bits per pixel
    int        comp            ; //  0           30 : no compression
    u_int      image_size      ; //              34 : in bytes
    u_int      xppm            ; //  2835        38 : pixels per meter
    u_int      yppm            ; //  2835        42 : approx. 72 dots per inch
    u_int      c_used          ; //              46 :
    u_int      c_important     ; //              50 : ................
    u_int      black           ; //              54 : non standard   |
    u_int      white           ; //              58 : added for ezfb |
    int        fd              ; //              62 :                |
    u_int      bytes_per_line  ; //              66 :                |
    u_int      palette_size    ; //              70 :                |
    u_int*     palette         ; //  null        74 :                |
    u_char*    image           ; //  null        78 :                |
    u_char*    data            ; //  null        82 :                |
};

//############################################################################
struct ezfb_rectangle
{
    int x1     ;
    int y1     ;
    int x2     ;
    int y2     ;
    int height ;
    int width  ;
};

//############################################################################
#endif

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################

/*
//############################################################################
//   from /usr/src/linux-2.4.xx/include/linux/fb.h
//############################################################################
#define FBIOGET_VSCREENINFO     0x4600
#define FBIOPUT_VSCREENINFO     0x4601
#define FBIOGET_FSCREENINFO     0x4602
#define FBIOGETCMAP             0x4604
#define FBIOPUTCMAP             0x4605
#define FBIOPAN_DISPLAY         0x4606
#define FBIOGET_CON2FBMAP       0x460F
#define FBIOPUT_CON2FBMAP       0x4610
#define FBIOBLANK               0x4611 // arg: 0 or vesa level + 1
#define FBIOGET_VBLANK          _IOR('F', 0x12, struct fb_vblank)
#define FBIO_ALLOC              0x4613
#define FBIO_FREE               0x4614
#define FBIOGET_GLYPH           0x4615
#define FBIOGET_HWCINFO         0x4616
#define FBIOPUT_MODEINFO        0x4617
#define FBIOGET_DISPINFO        0x4618

//############################################################################
struct fb_cmap
{
    __u32               start  ;  // First entry
    __u32               len    ;  // Number of etries
    __u16*              red    ;  // Red values
    __u16*              green  ;  // green values
    __u16*              blue   ;  // blue values
    __u16*              transp ;  // transparency, can be NULL
};

//############################################################################
struct fb_fix_screeninfo
{
    char                id[16]      ;  // identification string eg "TT Builtin"
    unsigned long       smem_start  ;  // Start of frame buffer mem (physical address)
    __u32               smem_len    ;  // Length of frame buffer mem
    __u32               type        ;  // see FB_TYPE_*
    __u32               type_aux    ;  // Interleave for interleaved Planes
    __u32               visual      ;  // see FB_VISUAL_*
    __u16               xpanstep    ;  // zero if no hardware panning
    __u16               ypanstep    ;  // zero if no hardware panning
    __u16               ywrapstep   ;  // zero if no hardware ywrap
    __u32               line_length ;  // length of a line in bytes
    unsigned long       mmio_start  ;  // Start of Memory Mapped I/O (physical address)
    __u32               mmio_len    ;  // Length of Memory Mapped I/O
    __u32               accel       ;  // Type of acceleration available
    __u16               reserved[3] ;  // Reserved for future compatibility
};

//############################################################################
struct fb_var_screeninfo
{
    __u32               xres           ;  // visible resolution
    __u32               yres           ;
    __u32               xres_virtual   ;  // virtual resolution
    __u32               yres_virtual   ;
    __u32               xoffset        ;  // offset from virtual to visible
    __u32               yoffset        ;  // resolution
    __u32               bits_per_pixel ;  // guess what
    __u32               grayscale      ;  // != 0 Graylevels instead of colors
    struct fb_bitfield  red            ;  // bitfield in fb mem if true color,
    struct fb_bitfield  green          ;  // else only length is significant
    struct fb_bitfield  blue           ;
    struct fb_bitfield  transp         ;  // transparency
    __u32               nonstd         ;  // != 0 Non standard pixel format
    __u32               activate       ;  // see FB_ACTIVATE_*
    __u32               height         ;  // height of picture in mm
    __u32               width          ;  // width of picture in mm
    __u32               accel_flags    ;  // acceleration flags (hints)
    __u32               pixclock       ;  // pixel clock in ps (pico seconds)
    __u32               left_margin    ;  // time from sync to picture
    __u32               right_margin   ;  // time from picture to sync
    __u32               upper_margin   ;  // time from sync to picture
    __u32               lower_margin   ;
    __u32               hsync_len      ;  // length of horizontal sync
    __u32               vsync_len      ;  // length of vertical sync
    __u32               sync           ;  // see FB_SYNC_*
    __u32               vmode          ;  // see FB_VMODE_*
    __u32               reserved[6]    ;  // Reserved for future compatibility
};

//############################################################################

#define FBIOGET_FCURSORINFO     0x4607
#define FBIOGET_VCURSORINFO     0x4608
#define FBIOPUT_VCURSORINFO     0x4609
#define FBIOGET_CURSORSTATE     0x460A
#define FBIOPUT_CURSORSTATE     0x460B

#define FB_CURSOR_OFF           0
#define FB_CURSOR_ON            1
#define FB_CURSOR_FLASH         2

struct fb_fix_cursorinfo
{
    __u16  crsr_width  ;  // width and height of the cursor in 
    __u16  crsr_height ;  // pixels (zero if no cursor)
    __u16  crsr_xsize  ;  // cursor size in display pixels
    __u16  crsr_ysize  ;
    __u16  crsr_color1 ;  // colormap entry for cursor color1
    __u16  crsr_color2 ;  // colormap entry for cursor color2
};

struct fb_var_cursorinfo
{
    __u16  width       ;
    __u16  height      ;
    __u16  xspot       ;
    __u16  yspot       ; 
    __u8   data[1]     ;  // field with [height][width]
};

struct fb_cursorstate
{
    __s16  xoffset     ;
    __s16  yoffset     ;
    __u16  mode        ;
};
//############################################################################
*/
