//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#include "ezfb.h"

//############################################################################
int try_bpp       (int bpp_wanted);
int draw_stuff    (int bpp);
int draw_stuff_32 ();
int draw_stuff_24 ();
int draw_stuff_16 ();
int draw_stuff_15 ();
int draw_stuff_8  ();
int draw_stuff_4  ();
int draw_stuff_2  ();
int draw_stuff_1  ();

void display_all_bmp_types();

//############################################################################
struct ezfb            fb       = {0};
struct ezfb_rectangle  bmp_area = {0};
struct ezfb_rectangle  fb_area  = {0};

//############################################################################
int main(int argc, char** argv)
{
    int we_have_32 = 0;
    int we_have_24 = 0;
    int we_have_16 = 0;
    int we_have_15 = 0;
    int we_have_8  = 0;
    int we_have_4  = 0;

EZFB_FUNCTION_CALL_0
#if EZFB_API_MESSAGES
    printf("Program begins:\n");
#endif
    if(argc > 1)
    {
        if(ezfb_name_to_num(argv[1])) // not /dev/fb0
        {
            if(!ezfb_init_named_no_save(&fb, argv[1])) // don't save video RAM
                exit(1);
        }
        else
        {
            if(!ezfb_init_named(&fb, argv[1]))
                exit(1);
        }
    }
    else if(!ezfb_init(&fb))
    {
        exit(1);
    }

    ezfb_clear(&fb);

    if(argc < 3)
    {
        we_have_32 = try_bpp(32);
        sleep(6);

        we_have_24 = try_bpp(24);
        sleep(6);

        we_have_16 = try_bpp(16);
        sleep(6);

        we_have_15 = try_bpp(15);
        sleep(6);

        we_have_8 = try_bpp(8);
        sleep(6);

        we_have_4 = try_bpp(4);
        sleep(6);

        if(we_have_32)
        {
            ezfb_set_bpp(&fb, 32);
            display_all_bmp_types();
        }

        if(we_have_24)
        {
            ezfb_set_bpp(&fb, 24);
            display_all_bmp_types();
        }

        if(we_have_16)
        {
            ezfb_set_bpp(&fb, 16);
            display_all_bmp_types();
        }

        if(we_have_15)
        {
            ezfb_set_bpp(&fb, 15);
            display_all_bmp_types();
        }

        if(we_have_8)
        {
            ezfb_set_bpp(&fb, 8);
            display_all_bmp_types();
        }

        if(we_have_4)
        {
            ezfb_set_bpp(&fb, 4);
            display_all_bmp_types();
        }

        if(we_have_8)
        {
            int i;
            ezfb_set_bpp(&fb, 8);
            ezfb_clear(&fb);
            draw_stuff_8();
            ezfb_set_cmap_grays(&fb);
            sleep(6);
            ezfb_set_cmap_reds(&fb);
            sleep(2);
            ezfb_set_cmap_greens(&fb);
            sleep(2);
            ezfb_set_cmap_blues(&fb);
            sleep(2);
            ezfb_set_cmap_hues(&fb);
            sleep(2);
            ezfb_set_cmap_reduction(&fb);
            sleep(2);
            ezfb_set_cmap_random(&fb);
            sleep(2);
            ezfb_set_cmap_smooth(&fb);
            for(i = 0; i < 256; i++)
            {
                ezfb_cycle_cmap(&fb, 0, 255, 1);
                usleep(1);
            }
            ezfb_set_cmap_smooth(&fb);
            for(i = 0; i < 256; i++)
            {
                ezfb_cycle_cmap(&fb, 0, 255, 1);
                usleep(1);
            }
            ezfb_set_cmap_smooth(&fb);
            for(i = 0; i < 256; i++)
            {
                ezfb_cycle_cmap(&fb, 0, 255, 1);
                usleep(1);
            }

            ezfb_clear_cmap(&fb);

            fb_area.x1 =  10;
            fb_area.y1 =  10;
            fb_area.x2 =  -1;
            fb_area.y2 =  -1;
            bmp_file_to_ezfb_at(&fb, "./bmp/leon.bmp", &fb_area);

            fb_area.x1 =  10;
            fb_area.y1 = fb.max_y - 160;
            fb_area.x2 =  -1;
            fb_area.y2 =  -1;
            bmp_file_to_ezfb_at(&fb, "./bmp/leon.bmp", &fb_area);

            fb_area.x1 = fb.max_x - 210;
            fb_area.y1 =  10;
            fb_area.x2 =  -1;
            fb_area.y2 =  -1;
            bmp_file_to_ezfb_at(&fb, "./bmp/leon.bmp", &fb_area);

            fb_area.x1 = fb.max_x - 210;
            fb_area.y1 = fb.max_y - 160;
            fb_area.x2 =  -1;
            fb_area.y2 =  -1;
            bmp_file_to_ezfb_at(&fb, "./bmp/leon.bmp", &fb_area);

            fb_area.x1 = fb.mid_x - 100;
            fb_area.y1 = fb.mid_y -  75;
            fb_area.x2 =  -1;
            fb_area.y2 =  -1;
            bmp_file_to_ezfb_at(&fb, "./bmp/leon.bmp", &fb_area);
        }
    }
    else
        try_bpp(atoi(argv[2]));

    ezfb_put_string(&fb, "     EZFB     ", fb.mid_x - 112,            60, fb.colors.black, fb.colors.white, 0, 2);
    ezfb_put_string(&fb, " HIT ANY KEY! ", fb.mid_x - 112, fb.max_y - 60, fb.colors.black, fb.colors.white, 0, 2);
    ezfb_wait_4_key();
    ezfb_release(&fb);
#if EZFB_API_MESSAGES
    printf("Program ends:\n");
#endif
EZFB_FUNCTION_RETURN(!ret)
}

//############################################################################
int try_bpp(int bpp_wanted)
{
EZFB_FUNCTION_CALL_1
    if((ret = ezfb_set_bpp(&fb, bpp_wanted)))
    {
        char file_name[42];
        ret &= ezfb_clear(&fb);
        ret &= draw_stuff(bpp_wanted);
        ret &= ezfb_printf(&fb, 12,  fb.max_y - 25,  fb.colors.black, fb.colors.white, 0, 1, "./bmp/%dbit.bmp", fb.Var.bits_per_pixel);
        printf("\n### %d x %d @ %d bpp ###\n", fb.Var.xres, fb.Var.yres, fb.Var.bits_per_pixel);
        //sprintf(file_name, "./bmp/%dx%d_%d.bmp", fb.Var.xres, fb.Var.yres, fb.Var.bits_per_pixel);
        sprintf(file_name, "./bmp/%dbit.bmp", fb.Var.bits_per_pixel);
        printf("\n%s = %d bytes\n", file_name, bmp_save_ezfb_as(&fb, file_name));
#ifdef EZFB_API_MESSAGES
        ret &= ezfb_dump_fb_fix_screeninfo  (&fb);
        ret &= ezfb_dump_fb_var_screeninfo  (&fb);
        ret &= ezfb_dump(&fb);
        ret &= ezfb_dump_colors        (&fb);
#endif
    }
    else
        ezfb_printf(&fb, 12,  fb.max_y - 25, fb.colors.black, fb.colors.white, 0, 3, "%2d bpp not supported", bpp_wanted);

EZFB_FUNCTION_RETURN(ret)
}

//############################################################################
int draw_stuff(int bpp)
{
EZFB_FUNCTION_CALL
    switch(bpp)
    {
        case  1: draw_stuff_1  (); break;
        case  2: draw_stuff_2  (); break;
        case  4: draw_stuff_4  (); break;
        case  8: draw_stuff_8  (); break;
        case 15: draw_stuff_15 (); break;
        case 16: draw_stuff_16 (); break;
        case 24: draw_stuff_24 (); break;
        case 32: draw_stuff_32 (); break;
        default:                   break;
    }
EZFB_FUNCTION_RETURN(1)
}

//############################################################################
int draw_stuff_32()
{
    u_int x, y;
EZFB_FUNCTION_CALL
    ezfb_clear(&fb);
    if(fb.Var.xres < 1530)
    {
        for(x = 0; x < 256; x++)
        {
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 +   0, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 +  59, ezfb_make_rgb(&fb, x/2, x/2, x/2));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 +  60, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 119, ezfb_make_rgb(&fb,   x,   0,   0));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 120, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 179, ezfb_make_rgb(&fb,   0,   x,   0));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 180, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 239, ezfb_make_rgb(&fb,   0,   0,   x));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 240, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 299, ezfb_make_rgb(&fb,   x,   x,   0));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 300, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 359, ezfb_make_rgb(&fb,   x,   0,   x));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 360, fb.Var.xres / 2 - 255 + x, fb.Var.yres / 2 - 210 + 419, ezfb_make_rgb(&fb,   0,   x,   x));

            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 +   0, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 +  59, ezfb_make_rgb(&fb, 127-(255-x/2), 127-(255-x/2), 127-(255-x/2) ));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 +  60, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 119, ezfb_make_rgb(&fb, 255, x, x));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 120, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 179, ezfb_make_rgb(&fb, x, 255, x));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 180, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 239, ezfb_make_rgb(&fb, x, x, 255));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 240, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 299, ezfb_make_rgb(&fb, 255, 255, x));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 300, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 359, ezfb_make_rgb(&fb, 255, x, 255));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 360, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 - 210 + 419, ezfb_make_rgb(&fb, x, 255, 255));
        }
    }
    else
    {
        ezfb_set_background(&fb, ezfb_make_rgb(&fb, 128, 128, 128));
        for(x = 0; x < 1530; x++)
            for(y = 0; y < 256; y++)
            {
                ezfb_put_pixel(&fb, fb.Var.xres / 2 - 765 + x, fb.Var.yres / 2 - 256 + y, ezfb_rgb_tint (&fb, x, 255 - y));
                ezfb_put_pixel(&fb, fb.Var.xres / 2 - 765 + x, fb.Var.yres / 2       + y, ezfb_rgb_shade(&fb, x, y));
            }
        for(x = 0; x < 256; x++)
        {
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x      , fb.Var.yres / 2 + 300, fb.Var.xres / 2 - 255 + x      , fb.Var.yres / 2 + 400, ezfb_make_rgb(&fb, x/2, x/2, x/2));
            ezfb_put_line(&fb, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 + 300, fb.Var.xres / 2 - 255 + x + 254, fb.Var.yres / 2 + 400, ezfb_make_rgb(&fb, 127-(255-x/2), 127-(255-x/2), 127-(255-x/2) ));
        }
    }
EZFB_FUNCTION_RETURN(1)
}

//############################################################################
int draw_stuff_24()
{
    u_int x, y;
EZFB_FUNCTION_CALL
    for(y = 0; y < fb.Var.yres; y++)
        for(x = 0; x < fb.Var.xres; x++)
            ezfb_put_pixel(&fb, x, y, ezfb_make_rgb( &fb,
                                          ( ~(0x180*x/fb.Var.xres) ^ (0x180*y/fb.Var.yres) ) &  (0x180*y/fb.Var.yres),
                                          ( ~(0x180*x/fb.Var.xres) & (0x180*y/fb.Var.yres) ) -  (0x180*x/fb.Var.xres),
                                          ( ~(0x180*x/fb.Var.xres) | (0x180*y/fb.Var.yres) ) & ((0x180*y/fb.Var.yres) - (0x180*x/fb.Var.xres)) ));
EZFB_FUNCTION_RETURN(1)
}

//############################################################################
int draw_stuff_16()
{
    u_int x, y;
EZFB_FUNCTION_CALL
    for(y = 0; y < fb.Var.yres; y++)
        for(x = 0; x < fb.Var.xres; x++)
            ezfb_put_pixel(&fb, x, y, ezfb_make_rgb(&fb, y - x, x * 5, y * 5));
EZFB_FUNCTION_RETURN(1)
}

//############################################################################
int draw_stuff_15()
{
    u_int x, y;
EZFB_FUNCTION_CALL
    for(y = 0; y < fb.Var.yres; y++)
        for(x = 2; x < fb.Var.xres; x++)
            ezfb_put_pixel(&fb, x, y, ezfb_make_rgb(&fb, (y-x)/16, x, y));
EZFB_FUNCTION_RETURN(1)
}

//############################################################################
int draw_stuff_8()
{
    u_int i, j, k = 0, x, y;
EZFB_FUNCTION_CALL
    for(i = 0; i < 16; i++)
        for(j = 0; j < 16; j++)
        {
            for(y = 0; y < (fb.Var.yres / 24 - 1); y++)
                for(x = 0; x < (fb.Var.xres / 16 - 1); x++)
                    ezfb_put_pixel(&fb, j * (fb.Var.xres / 16) + x, i * (fb.Var.yres / 24) + y, k);
            k++;
        }
    for(i = 0; i < fb.max_x; i++)
    {
        ezfb_put_line(&fb, i           , fb.Var.yres * 2 / 3, i           , fb.Var.yres * 5 / 6, i % 256);
        ezfb_put_line(&fb, fb.max_x - i, fb.Var.yres * 5 / 6, fb.max_x - i, fb.max_y           , i % 256);
    }
EZFB_FUNCTION_RETURN(1)
}

//############################################################################
int draw_stuff_4()
{
    u_int i, j, k, x, y;
EZFB_FUNCTION_CALL
    k = 0;
    for(i = 0; i < 16; i++)
        for(j = 0; j < 16; j++)
        {
            for(y = 0; y < (fb.Var.yres / 24 - 1); y++)
                for(x = 0; x < (fb.Var.xres / 16 - 1); x++)
                    ezfb_put_pixel(&fb, j * (fb.Var.xres / 16) + x, i * (fb.Var.yres / 24) + y, k);
            k++;
        }
    for(i = 0; i < fb.max_x; i++)
    {
        ezfb_put_line(&fb, i           , fb.Var.yres * 2 / 3, i           , fb.Var.yres * 5 / 6, i % 16);
        ezfb_put_line(&fb, fb.max_x - i, fb.Var.yres * 5 / 6, fb.max_x - i, fb.max_y           , i % 16);
    }
EZFB_FUNCTION_RETURN(1)
}

//############################################################################
int draw_stuff_2()
{
EZFB_FUNCTION_CALL
EZFB_FUNCTION_RETURN(1)
}

//############################################################################
int draw_stuff_1()
{
EZFB_FUNCTION_CALL
EZFB_FUNCTION_RETURN(1)
}


//############################################################################
void display_all_bmp_types()
{
    bmp_file_to_ezfb_center(&fb, "./bmp/24bit.bmp");
    ezfb_printf(&fb, 50, 50, fb.colors.black, fb.colors.white, 0, 1, "24 bpp bmp in %d bpp fb", fb.Var.bits_per_pixel);
    sleep(6);
    bmp_file_to_ezfb_center(&fb, "./bmp/8bit.bmp");
    ezfb_printf(&fb, 50, 50, fb.colors.black, fb.colors.white, 0, 1, "8 bpp bmp in %d bpp fb", fb.Var.bits_per_pixel);
    sleep(6);
    bmp_file_to_ezfb_center(&fb, "./bmp/4bit.bmp");
    ezfb_printf(&fb, 50, 50, fb.colors.black, fb.colors.white, 0, 1, "4 bpp bmp in %d bpp fb", fb.Var.bits_per_pixel);
    sleep(6);
    bmp_file_to_ezfb_center(&fb, "./bmp/1bit.bmp");
    ezfb_printf(&fb, 50, 50, fb.colors.black, fb.colors.white, 0, 1, "1 bpp bmp in %d bpp fb", fb.Var.bits_per_pixel);
    sleep(6);
}

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################







