//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#include "ezfb.h"

//############################################################################
struct ezfb fb = {0};

//############################################################################
int main(int argc, char** argv)
{
EZFB_FUNCTION_CALL_0
#if EZFB_API_MESSAGES
    printf("Program begins:\n");
#endif
    if(argc > 2)
    {
        if(!ezfb_init_named_no_save(&fb, argv[2]))
            exit(1);
    }
    else
    {
        if(!ezfb_init_no_save(&fb))
            exit(1);
    }

    if(argc > 1)
        bmp_save_ezfb_as(&fb, argv[1]);
    else
        bmp_save_ezfb_as(&fb, "grab.bmp");
    ezfb_release(&fb);
#if EZFB_API_MESSAGES
    printf("Program ends:\n");
#endif
EZFB_FUNCTION_RETURN(!ret)
}

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################


