#include "ezfb.h"

//##########################################################
u_int XSIZE, XSize, YSIZE, YSize;

//##########################################################
void f0(), f1(), f2(), f3(), f4(), f5(), f6(), f7(), f8(), f9(), f10(), f11(),
     c0(), c1(), c2(), c3(), c4(), c5(), c6(), c7(), c8(), c9(), c10(), c11(),
     c12(), c13(), c14(), c15(), c16(), c17(), c18(),
     changescreen (int which),
     fillscreen   (int which),
     palette      (int which);

int check_for_blank(void);

//##########################################################
struct ezfb        fb  = {0};
struct ezfb_bitmap bmp = {0};

//##########################################################
//******************** MAIN ********************************
int main(int argc, char** argv)
{
    char c;
    int  i,
         cycle = 0;

EZFB_FUNCTION_CALL_0
#if EZFB_API_MESSAGES
    printf("Program begins:\n");
#endif
    if(argc > 1)
    {
        if(ezfb_name_to_num(argv[1])) // not /dev/fb0
        {
            if(!ezfb_init_named_no_save(&fb, argv[1])) // don't save video RAM
                exit(1);
        }
        else
        {
            if(!ezfb_init_named(&fb, argv[1]))
                exit(1);
        }
    }
    else if(!ezfb_init(&fb))
    {
        exit(1);
    }

    if(ezfb_set_bpp(&fb, 8))
    {
        bmp_file_to_ezfb_center(&fb, "./bmp/me.bmp");
        XSize = fb.max_x;
        XSIZE = XSize + 1;
        YSize = fb.max_y;
        YSIZE = YSize + 1;
        if(argc > 2)
        {
            ezfb_put_string(&fb, "hit a-s, A-L, 1-9, 0, +, =, x to quit", (XSize - 640) / 2 + 10, (YSize - 480) / 2 +  10, 0, -1, 0, 2);

            while(1)
            {
                while(0 == (c = ezfb_kb_hit()))
                {
                    usleep(1);
                    ezfb_cycle_cmap(&fb, 0, 255, cycle);
                }
                if('0' == c) cycle =  0;
                if('-' == c) cycle -= 1;
                if('=' == c) cycle += 1;
                changescreen (c - 'a');
                fillscreen   (c - 'A');
                palette      (c - '1');
                if(('x' == c) || ('X' == c)) break;
            }
        } 
        else
        {
            while(!ezfb_kb_hit())
            {
                ezfb_set_cmap_smooth(&fb);
                if(random() % 15 == 5)
                    ezfb_set_cmap_random(&fb);
                changescreen(random() % 19);
                while(check_for_blank())
                    fillscreen(random() % 12);
                for(i = 0; i < 200; i++)
                {
                    ezfb_cycle_cmap(&fb, 0, 255, 1);
                    usleep(1);
                } 
                if(random() % 15 == 5)
                    while(check_for_blank())
                        fillscreen(random() % 12);
            }
        }
    }
    else
        printf("\n\n8 bits per pixel not supported.\n\n");

    ezfb_release(&fb);

#if EZFB_API_MESSAGES
    printf("Program ends:\n");
#endif

EZFB_FUNCTION_RETURN(!ret)
}

//##########################################################
void f0(void) // A
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, x % 256);
    }
}

//##########################################################
void f1(void) // B
{
    u_int x, y, xa, ya, num, num1;
    num = random() % 300 + 10;
    for(x = 0; x < XSIZE; x += num)
    {
        for(y = 0; y < YSIZE; y += num)
        {    num1 = random() % 256;
            for(xa = 0; xa < num; xa++)
            for(ya = 0; ya < num; ya++)
                ezfb_put_pixel(&fb, x + xa, y + ya, num1);
        }
    }
}

//##########################################################
void f2(void) // C
{
    u_int x, y, z;
    z = random() % 100 + 1;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, (z * x / (y + 1)) % 256);
    }
}

//##########################################################
void f3(void) // D
{
    u_int x, y, z;
    z = random() % 200 + 10;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, ((x % z) + y) % 256);
    }
}

//##########################################################
void f4(void) // E
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, 255 * x / XSIZE);
    }
}

//##########################################################
void f5(void) // F
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, y % 256);
    }
}

//##########################################################
void f6(void) // G
{
    u_int x, y, z, w;
    w = random() % 400 + 10;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
        {    if((z = (x % w)) > (w / 2))
                ezfb_put_pixel(&fb, x, y, (y + z) % 256);
            else
                ezfb_put_pixel(&fb, x, y, (y - z) % 256);
        }
    }
}

//##########################################################
void f7(void) // H
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, abs(y - x) % 256);
    }
}

//##########################################################
void f8(void) // I
{
    u_int x, y, w;
    float z;
    z = ezfb_random_01() * 40 + 1;
    w = random() % 120 + 10;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, abs((int)(sin(y / z) * sin(x / w) * 256)) % 256);
    }
}

//##########################################################
void f9(void) // J
{
    u_int x, y, w;
    float z;
    z = ezfb_random_01() * 40 + 1;
    w = random() % 120 + 10;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, abs((int)(sin(y / w) * sin(x / z) * 256)) % 256);
    }
}

//##########################################################
void f10(void) // K
{
    u_int x, y;
    float z;
    z = ezfb_random_01() * 100 + 1;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, abs((int)(sin(y / z) * sin(x / z) * 256)) % 256);
    }
}

//##########################################################
void f11(void) // L
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, 255 * (x + y) / (XSIZE + YSIZE));
    }
}




//##########################################################
void c0(void) // a
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, (x + ezfb_get_pixel(&fb, x, y)) % 256);
    }
    return;
}

//##########################################################
void c1(void) // b
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, (y + ezfb_get_pixel(&fb, x, y)) % 256);
    }
    return;
}

//##########################################################
void c2(void) // c
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, (abs(x - y) * ezfb_get_pixel(&fb, x, y)) % 256);
    }
    return;
}

//##########################################################
void c3(void) // d
{
    u_int x, y, z;
    z = (int)(ezfb_random_01() * 100);
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, ezfb_get_pixel(&fb, (z * x) % XSIZE, (z * y) % YSIZE));

    }
    return;
}

//##########################################################
void c4(void) // e
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, (x + y + ezfb_get_pixel(&fb, x, y)) % 256);
    }
    return;
}

//##########################################################
void c5(void) // f
{
    u_int x, y;
    float z = ezfb_random_01() * 10 + 1;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, XSIZE - x, YSIZE - y, ezfb_get_pixel(&fb, (int)(x / z), (int)(y / z)));

    }
    return;
}

//##########################################################
void c6(void) // g
{
    u_int x, y, z;
    z = (int)(ezfb_random_01() * 10 + 1);
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, ezfb_get_pixel(&fb, (x * z) % XSIZE, (y * z) % YSIZE));
    }
    return;
}

//##########################################################
void c7(void) // h
{
    u_int x, y, z;
    z = (int)(ezfb_random_01() * 4);
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
        {
            switch(z)
            {
                case 0: ezfb_put_pixel(&fb,         x,         y, ezfb_get_pixel(&fb,    (x + y) % XSIZE, abs(x - y) % YSIZE));
                        break;
                case 1: ezfb_put_pixel(&fb,         x,         y, ezfb_get_pixel(&fb, abs(x - y) % XSIZE,    (x + y) % YSIZE));
                        break;
                case 2: ezfb_put_pixel(&fb, XSIZE - x, YSIZE - y, ezfb_get_pixel(&fb,    (x + y) % XSIZE, abs(x - y) % YSIZE));
                        break;
                case 3: ezfb_put_pixel(&fb, XSIZE - x, YSIZE - y, ezfb_get_pixel(&fb, abs(x - y) % XSIZE,    (x + y) % YSIZE));
                        break;
            }
        }
    }
    return;
}

//##########################################################
void c8(void) // i
{
    u_int x, y, z;
    z = (int)(random() % 40 + 20);
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, ezfb_get_pixel(&fb, (x + (x % z)) % XSIZE, (y + (y % z)) % YSIZE));
    }
    return;
}

//##########################################################
void c9(void) // j
{
    u_int x, y, z;
    z = (int)(random() % 20 + 2);
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, XSIZE - x, YSIZE - y, ezfb_get_pixel(&fb, (z * x + y) % XSIZE, (z * y + x) % YSIZE));
    }
    return;
}

//##########################################################
void c10(void) // k
{
    u_int x, y, z;
    z = (int)(random() % 40 + 20);
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, ezfb_get_pixel(&fb, (x + (y % z)) % XSIZE, (y + (x % z)) % YSIZE));
    }
    return;
}

//##########################################################
void c11(void) // l
{
    u_int x, y;
    float v = random() %  10 + 1,
          w = random() % 200 + 1,
          z = random() % 200 + 1;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y,
                              (   ezfb_get_pixel(&fb, x, y) + abs((int)(v * (sin(y / w) * sin(x / z)) * 256))     )
                            % 256);
    }
    return;
}

//##########################################################
void c12(void) // m
{
    u_int x, y, z;
    z = (int)(random() % 20 + 1);
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, (ezfb_get_pixel(&fb, x, y) + ezfb_get_pixel(&fb, (x + z) % XSIZE, (y + 1) % YSIZE)) / 2);
    }
    return;
}

//##########################################################
void c13(void) // n
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, (y + ezfb_get_pixel(&fb, x, y)) % 256);
    }
    return;
}

//##########################################################
void c14(void) // o
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, XSIZE - x, YSIZE - y, (y + ezfb_get_pixel(&fb, x, y)) % 256);
    }
    return;
}

//##########################################################
void c15(void) // p
{
    u_int x, y;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, ezfb_get_pixel(&fb, (int)(y * 1.333), (int)(x * 0.75)));
    }
    return;
}

//##########################################################
void c16(void) // q
{
    u_int x, y, xa, ya, num, num1;
    num = random() % 100 + 10;
    for(x = 0; x < XSIZE; x += num)
    {
        for(y = 0; y < YSIZE; y += num)
        {    num1 = random() % 256;
            for(xa = 0; xa < num; xa++)
            for(ya = 0; ya < num; ya++)
               ezfb_put_pixel(&fb, x + xa, y + ya, (ezfb_get_pixel(&fb, (x + xa) % XSIZE, (y + ya) % YSIZE) + num1) % 256);
        }
    }
}

//##########################################################
void c17(void) // r
{
    u_int x, y, z;
    z = random() % 20 + 1;
//    while(z--)
//    {
        for(x = 0; x < XSIZE; x++)
        {
            for(y = 0; y < YSIZE; y++)
                ezfb_put_pixel(&fb, x, y, (    ezfb_get_pixel(&fb, (x - 1) % XSIZE, (y + 1) % YSIZE)
                                   + ezfb_get_pixel(&fb, (x - 1) % XSIZE,  y             )
                                   + ezfb_get_pixel(&fb, (x - 1) % XSIZE, (y - 1) % YSIZE)
                                   + ezfb_get_pixel(&fb,  x             , (y + 1) % YSIZE)
                                   + ezfb_get_pixel(&fb,  x             ,  y             )
                                   + ezfb_get_pixel(&fb,  x             , (y - 1) % YSIZE)
                                   + ezfb_get_pixel(&fb, (x + 1) % XSIZE, (y - 1) % YSIZE)
                                   + ezfb_get_pixel(&fb, (x + 1) % XSIZE,  y             )
                                   + ezfb_get_pixel(&fb, (x + 1) % XSIZE, (y + 1) % YSIZE)
                                ) / 9);
        }
//    }
    return;
}

//##########################################################
void c18(void) // s
{
    u_int w, x, y, z;
    z = random() % 20 + 1;
    w = random() % 255;
    for(x = 0; x < XSIZE; x++)
    {
        for(y = 0; y < YSIZE; y++)
            ezfb_put_pixel(&fb, x, y, (w + ((     ezfb_get_pixel(&fb, (x - z) % XSIZE, (y + z) % YSIZE)
                                      + ezfb_get_pixel(&fb, (x - z) % XSIZE,  y             )
                                      + ezfb_get_pixel(&fb, (x - z) % XSIZE, (y - z) % YSIZE)
                                      + ezfb_get_pixel(&fb,  x             , (y + z) % YSIZE)

                                      + ezfb_get_pixel(&fb,  x             , (y - z) % YSIZE)
                                      + ezfb_get_pixel(&fb, (x + z) % XSIZE, (y - z) % YSIZE)
                                      + ezfb_get_pixel(&fb, (x + z) % XSIZE,  y             )
                                      + ezfb_get_pixel(&fb, (x + z) % XSIZE, (y + z) % YSIZE)
                                   ) / 8)) % 256);
    }
    return;
}

//##########################################################
void changescreen(int which)
{
    switch(which)
    {
        case  0: c0  ();  break;
        case  1: c1  ();  break;
        case  2: c2  ();  break;
        case  3: c3  ();  break;
        case  4: c4  ();  break;
        case  5: c5  ();  break;
        case  6: c6  ();  break;
        case  7: c7  ();  break;
        case  8: c8  ();  break;
        case  9: c9  ();  break;
        case 10: c10 ();  break;
        case 11: c11 ();  break;
        case 12: c12 ();  break;
        case 13: c13 ();  break;
        case 14: c14 ();  break;
        case 15: c15 ();  break;
        case 16: c16 ();  break;
        case 17: c17 ();  break;
        case 18: c18 ();  break;
        default:          break;
    }
    return;
}

//##########################################################
void fillscreen(int which)
{
    switch(which)
    {
        case  0: f0  (); break;
        case  1: f1  (); break;
        case  2: f2  (); break;
        case  3: f3  (); break;
        case  4: f4  (); break;
        case  5: f5  (); break;
        case  6: f6  (); break;
        case  7: f7  (); break;
        case  8: f8  (); break;
        case  9: f9  (); break;
        case 10: f10 (); break;
        case 11: f11 (); break;
        default:         break;
    }
    return;
}

//##########################################################
void palette(int which)
{
    switch(which)
    {
        case  0: ezfb_set_cmap_to_was     (&fb);  break;
        case  1: ezfb_set_cmap_grays      (&fb);  break;
        case  2: ezfb_set_cmap_reds       (&fb);  break;
        case  3: ezfb_set_cmap_greens     (&fb);  break;
        case  4: ezfb_set_cmap_blues      (&fb);  break;
        case  5: ezfb_set_cmap_utility    (&fb);  break;
        case  6: ezfb_set_cmap_hues       (&fb);  break;
        case  7: ezfb_set_cmap_smooth     (&fb);  break;
        case  8: ezfb_set_cmap_random     (&fb);  break;
        case  9: ezfb_set_cmap_reduction  (&fb);  break;
            
        default:                                break;
    }
    return;
}

//##########################################################
int check_for_blank(void)
{
    u_int x, y, c;
    c = ezfb_get_pixel(&fb, 1, 1);
    for(x = 0; x < XSIZE; x += 10)
    {
        for(y = 0; y < YSIZE; y += 10)
            if(c != ezfb_get_pixel(&fb, x, y))
                return 0;
    }
    return 1;
}

//##########################################################
////////////////////////////////////////////////////////////
//##########################################################


