//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#include "ezfb.h"

//############################################################################
struct ezfb fb = {0};

//############################################################################
int main()
{
    int c = 0;
    float t, pi = 4 * atan(1.0);
EZFB_FUNCTION_CALL_0
#if EZFB_API_MESSAGES
    printf("Program begins:\n");
#endif
    if(!ezfb_init(&fb))
        exit(1);
    ezfb_clear(&fb);
    if(ezfb_set_bpp(&fb, 8))
    {
        ezfb_set_cmap_smooth(&fb);
        for(t = 0; t < (2 * pi); t += (pi / 8192))
            ezfb_put_ray(&fb, fb.mid_x
                      , fb.mid_y
                      , fb.mid_y
                      , t
                      , ((c++ >> 6) % 255) + 1);
        while(!ezfb_kb_hit())
        {
            usleep(1);
            ezfb_cycle_cmap(&fb, 1, 255, 1);
        }
        ezfb_wait_4_key();
        bmp_save_ezfb_as(&fb, "bmp/lines.bmp");
    }
    else
        printf("\n\n8 bits per pixel not supported.\n\n");
    ezfb_release(&fb);
#if EZFB_API_MESSAGES
    printf("Program ends:\n");
#endif
EZFB_FUNCTION_RETURN(!ret)
}

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################



