//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################
#include "ezfb.h"

struct ezfb *fb_array[32] = {0};

//############################################################################
int main()
{
    int n            = 0,
        num_valid_fb = 0;

EZFB_FUNCTION_CALL_0
#if EZFB_API_MESSAGES
    printf("Program begins:\n");
#endif
    while(ezfb_num_exists(n))
    {
        fb_array[n] = (struct ezfb*)malloc(sizeof(struct ezfb));
        if(ezfb_init(fb_array[n]))
        {
            ezfb_clear(fb_array[n]);
            if(fb_array[n]->Var.bits_per_pixel <= 8)
                ezfb_set_cmap_reduction(fb_array[n]);
            n++;
            num_valid_fb++;
        }
        else
            break;
    }
    n = 0;
    while(!ezfb_kb_hit())
    {
        ezfb_put_rectangle(fb_array[n], random() % fb_array[n]->max_x,
                                        random() % fb_array[n]->max_y,
                                        random() % fb_array[n]->max_x,
                                        random() % fb_array[n]->max_y,
                                        random()                     ,
                                        random() % 2                   );
        n++;
        if(n == num_valid_fb)
            n = 0;
    };
    for(n = 0; n < num_valid_fb; n++)
    {
        ezfb_release(fb_array[n]);
        free(fb_array[n]);
    }
#if EZFB_API_MESSAGES
    printf("Program ends:\n");
#endif
EZFB_FUNCTION_RETURN(!ret)
}

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################

