//############################################################################
//
// EZFB ~ Linux Frame Buffer API ~
//
// by James Lehman
// james@akrobiz.com
//
// began: Feb. 2001
//
// EZFB is intended to give C programmers an easy-to-use library of functions
// for drawing points, lines and strings of characters into the Linux frame
// buffer. It also provides a means of displaying bitmap images on any portion
// of the screen and capturing the contents of any portion of the screen to
// a standard bitmap graphics file. All of this is embodied in a set of
// functions that are polymorphic with regard to the characteristics of the
// frame buffer and the bitmap files used. In other words, it makes no
// difference what the screen height or width is or what the color depth is,
// all of the function calls are the same and will have appropriate and
// predictable effects.
//
// This software is distributed in the hope that it will be useful, but
// without any warranty; without even the implied warranty of merchantability
// or fitness for a particular purpose. See the GNU General Public License
// for more details.
//
//############################################################################

#include "ezfb.h"

//############################################################################
struct ezfb fb = {0};

//############################################################################
int main(int argc, char** argv)
{
    int     key ;
    u_int   xoff, yoff;

EZFB_FUNCTION_CALL_0
#if EZFB_API_MESSAGES
    printf("Program begins:\n");
#endif
    if(argc > 2)
    {
        if(ezfb_name_to_num(argv[2])) // not /dev/fb0
        {
            if(!ezfb_init_named_no_save(&fb, argv[2])) // don't save video RAM
                exit(1);
        }
        else
        {
            if(!ezfb_init_named (&fb, argv[2]))
                exit(1);
        }
    }
    else if(!ezfb_init(&fb))
    {
        exit(1);
    }

    ezfb_dump_fb_var_screeninfo (&fb);
    ezfb_set_xy_virtual         (&fb, fb.Var.xres * 2, fb.Var.yres * 2);
    ezfb_dump_fb_var_screeninfo (&fb);

    xoff = fb.Var.xres / 2;
    yoff = fb.Var.yres / 2;
    ezfb_set_xy_offsets         (&fb, xoff, yoff);

    ezfb_dump_fb_var_screeninfo (&fb);

    ezfb_clear_screen(&fb);

    if(argc > 1)
        bmp_file_to_ezfb_center (&fb, argv[1]);
    else
        bmp_file_to_ezfb_center (&fb, "bmp/me.bmp");

    while((key = ezfb_get_key()) != EZFB_ESCAPE_KEY) // from ezfb_tty.c
    { // ezfb_get_key() accepts a single key stroke with no return
        switch(key)
        {            
            case EZFB_ARROW_LEFT:
                         xoff += 8;
                         if(xoff >= (fb.Var.xres_virtual - fb.Var.xres))
                             xoff = (fb.Var.xres_virtual - fb.Var.xres);
                         ezfb_set_xy_offsets(&fb, xoff, yoff);
                         break;
            //----------------------------------------------------------------
            case EZFB_ARROW_RIGHT:
                         xoff -= 8;
                         if(xoff < 0)
                             xoff = 0;
                         ezfb_set_xy_offsets(&fb, xoff, yoff);
                         break;
            //----------------------------------------------------------------
            case EZFB_ARROW_UP:
                         yoff += 1;
                         if(yoff >= fb.Var.yres_virtual - fb.Var.yres)
                             yoff = fb.Var.yres_virtual - fb.Var.yres;
                         ezfb_set_xy_offsets(&fb, xoff, yoff);
                         break;
            //----------------------------------------------------------------
            case EZFB_ARROW_DOWN:
                         yoff -= 1;
                         if(yoff < 0)
                             yoff = 0;
                         ezfb_set_xy_offsets(&fb, xoff, yoff);
                         break;
            //----------------------------------------------------------------
            case EZFB_BACKSPACE_KEY:
                         xoff = yoff = 0;
                         ezfb_set_xy_offsets(&fb, xoff, yoff);
                         break;
            //----------------------------------------------------------------
        }
    }
    ezfb_release(&fb);
#if EZFB_API_MESSAGES
    printf("Program ends:\n");
#endif
EZFB_FUNCTION_RETURN(!ret)
}

//############################################################################
//////////////////////////////////////////////////////////////////////////////
//############################################################################


